#include "stdafx.h"
#include "DS_SystemManager.h"


bool CDS_SystemManager::instanceFlag = false;
CDS_SystemManager* CDS_SystemManager::single = NULL;


bool CDS_SystemManager::Calculate_API()
{
	//////////////////////////////////////////////////////////////
	//do not remove
	//////////////////////////////////////////////////////////////
#ifdef _EXE_CONSOLE
	m_bInExecutableMode = true;
#else
	m_bInExecutableMode = false;
#endif
	// this flag can be useful for some parameters to be adjusted depending on the mode

	InitializeGlobals(); //set some of the key global parameters so they are avaliable in debug mode
	//////////////////////////////////////////////////////////////
	//do not remove
	//////////////////////////////////////////////////////////////


	/////////////////////////////////////////////////////////////
	//Below is an example of how to create a data console to display output and also write the output to Windows Notepad
	/////////////////////////////////////////////////////////////
	//Console myConsole;
	//string buffer;
	//myConsole << "test 1\n";
	//buffer += "test 1\n";
	//double dDataValue = 1234.567;
	//myConsole << "test 2 " << dDataValue << " test 3 \n";
	//buffer += "test 2 " + to_string(dDataValue) + " test 3 \n";
	//system("pause");
	//Notepad(buffer);
	////////////////////////////////////////////////////////////////////////

	//////////////////////////////////////////////// BINARY SIGNAL LOADING///////////////////////////////////////////////////
	CDS_SignalBase* pIOSignal1 = GetSignalFromInputPort(1);
	//Load the data from the first input port. At this point we are just loading it into our parent data class : CDS_SignalBase

	if (pIOSignal1 != NULL)
	{
		if (pIOSignal1->GetSignalName() == "BinarySignal")
		{

			CDS_BinarySignal binarySignal1 = GetBinarySignal(pIOSignal1);
			//get the binary signal from the input port

			//////////////////////////////////////////////// DATA MANIPULATION///////////////////////////////////////////////////
			for (int i = 0; i < binarySignal1.m_Bits.size(); i++)
			{
				
				binarySignal1.m_Bits[i] = (binarySignal1.m_Bits[i] + 1) % 2;
			}
			//if value = 0 -> 1, if value = 1 -> 0
			//////////////////////////////////////////////// DATA MANIPULATION//////////////////////////////////////////////////



			//////////////////////////////////////////////// BINARY SIGNAL OUTPUT///////////////////////////////////////////////////
			CDS_SignalBase* pOOSignal1 = GetSignalFromOutputPort(1);
			//create an output port
			if (pOOSignal1 != NULL)
			{
				if (pOOSignal1->GetSignalName() == "BinarySignal")
				{
					PutBinarySignal(binarySignal1, pOOSignal1);
					//put the binary signal onto the output port
				}
				else
				{
					return 0; //returns warning to OptiSystem -- output is not set correctly to binary
				} //if (pOOSignal1->GetSignalName() == "BinarySignal")
			} //if (pOOSignal1 != NULL)
			else
			{
				return 0; //returns warning to OptiSystem -- output put not created
			}

		} //if (pIOSignal1 != NULL)
	} //if (pIOSignal1->GetSignalName() == "BinarySignal")

	

	SaveOutputDataToFiles();//for debugging purposes
	////////////////////////////////////////
	return 1; //for successful run
}




///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// convenience functions for user to access signals
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
CDS_MarySignal CDS_SystemManager::GetMarySignal(CDS_SignalBase* pSignalBase)
{
	CDS_MarySignal marySignal;
	DOUBLEVECTOR* pvnData1 = ((CDS_MarySignal*)pSignalBase)->GetSymbols();
	//get the pointer to the doublevector that holds the Mary data's symbols
	DOUBLEVECTOR &vecTemp = *pvnData1;
	//Copy the data onto a vector of doubles vector<double> which we have defined as DOUBLEVECTOR
	marySignal.m_Symbols.clear();

	for (int i = 0; i < vecTemp.size(); i++)
	{
		marySignal.m_Symbols.push_back(vecTemp[i]);
	}
	marySignal.SetSymbolRate(((CDS_MarySignal*)pSignalBase)->GetSymbolRate());
	return marySignal;
}


void CDS_SystemManager::PutMarySignal(CDS_MarySignal marySignal, CDS_SignalBase* pSignalBase)
{
	((CDS_MarySignal*)pSignalBase)->SetSymbolRate(marySignal.GetSymbolRate());
	((CDS_MarySignal*)pSignalBase)->m_Symbols.resize(marySignal.m_Symbols.size());
	//make sure the output symbol sequence has the appropriate size
	for (int i = 0; i < marySignal.m_Symbols.size(); i++)
	{
		((CDS_MarySignal*)pSignalBase)->m_Symbols[i] = marySignal.m_Symbols[i];
	}
	//copy the manipulated data onto the output signal, m_Symbols is a double vector that holds the classes' Mary data
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}




CDS_BinarySignal CDS_SystemManager::GetBinarySignal(CDS_SignalBase* pSignalBase)
{
	CDS_BinarySignal binarySignal;
	LONGVECTOR* pvnData1 = ((CDS_BinarySignal*)pSignalBase)->GetBits();
	//get the pointer to the longvector that holds the binary data's bits
	LONGVECTOR &vecTemp = *pvnData1;
	//Copy the data onto a vector of doubles vector<double> which we have defined as DOUBLEVECTOR
	binarySignal.m_Bits.clear();

	for (int i = 0; i < vecTemp.size(); i++)
	{
		binarySignal.m_Bits.push_back(vecTemp[i]);
	}
	binarySignal.SetBitRate(((CDS_BinarySignal*)pSignalBase)->GetBitRate());
	return binarySignal;
}


void CDS_SystemManager::PutBinarySignal(CDS_BinarySignal binarySignal, CDS_SignalBase* pSignalBase)
{
	((CDS_BinarySignal*)pSignalBase)->SetBitRate(binarySignal.GetBitRate());
	((CDS_BinarySignal*)pSignalBase)->m_Bits.resize(binarySignal.m_Bits.size());
	//make sure the output bit sequence has the appropriate size
	for (int i = 0; i < binarySignal.m_Bits.size(); i++)
	{
		((CDS_BinarySignal*)pSignalBase)->m_Bits[i] = binarySignal.m_Bits[i];
	}
	//copy the manipulated data onto the output signal, m_Bits is a double vector that holds the classes' Mary data
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}





VECTOR_OpticalSampledSignals  CDS_SystemManager::GetOpticalSampledSignalsVector(CDS_SignalBase* pSignalBase)
{
	VECTOR_OpticalSampledSignals returnSig;
	CNDS_OpticalSampledSignalsData Signals1(((CDS_OpticalSignal*)pSignalBase)->GetSampledSignals());
	CNDS_OpticalSampledSignal* pSampSignals =  Signals1.GetData();
	for (int i = 0; i < Signals1.GetSize(); i++)
	{
		returnSig.push_back(pSampSignals[i]);
	}
	return returnSig;
}

void  CDS_SystemManager::PutOpticalSampledSignalsVector(VECTOR_OpticalSampledSignals vecSampledSignals, CDS_SignalBase* pOOSignal)
{
	CNDS_OpticalSampledSignalsData SignalsOut;

	//Add each sampled signal to output data structures
	for (int i = 0; i < vecSampledSignals.size(); i++)
	{
		SignalsOut.Add(vecSampledSignals[i]);
	}
	COpticalSampledSignalsArray* pSignalsOutput1;
	pSignalsOutput1 = ((CDS_OpticalSignal*)pOOSignal)->GetSampledSignals();
	SignalsOut.GetData(pSignalsOutput1);


}



VECTOR_OpticalParameterizedSignals  CDS_SystemManager::GetOpticalParameterizedSignalsVector(CDS_SignalBase* pSignalBase)
{
	VECTOR_OpticalParameterizedSignals returnSig;
	CNDS_OpticalParameterizedSignalsData Signals1(((CDS_OpticalSignal*)pSignalBase)->GetParameterizedSignals());
	CNDS_OpticalParameterizedSignal* pParamSignals = Signals1.GetData();
	for (int i = 0; i < Signals1.GetSize(); i++)
	{
		returnSig.push_back(pParamSignals[i]);
	}
	return returnSig;
}


void  CDS_SystemManager::PutOpticalParameterizedSignalsVector(VECTOR_OpticalParameterizedSignals vecParamSignals, CDS_SignalBase* pOOSignal)
{
	CNDS_OpticalParameterizedSignalsData SignalsOut;

	//Add each sampled signal to output data structures
	for (int i = 0; i < vecParamSignals.size(); i++)
	{
		SignalsOut.Add(vecParamSignals[i]);
	}
	COpticalParameterizedSignalsArray* pSignalsOutput1;
	pSignalsOutput1 = ((CDS_OpticalSignal*)pOOSignal)->GetParameterizedSignals();
	SignalsOut.GetData(pSignalsOutput1);


}




VECTOR_OpticalIndividualSamples  CDS_SystemManager::GetOpticalIndividualSamplesVector(CDS_SignalBase* pSignalBase)
{
	VECTOR_OpticalIndividualSamples returnSample;
	CNDS_OpticalIndividualSamplesData Samples(((CDS_OpticalSignal*)pSignalBase)->GetIndividualSamples());
	CNDS_OpticalIndividualSample* pIndividualSamples = Samples.GetData();
	for (int i = 0; i < Samples.GetSize(); i++)
	{
		returnSample.push_back(pIndividualSamples[i]);
	}
	return returnSample;
}


void  CDS_SystemManager::PutOpticalIndividualSamplesVector(VECTOR_OpticalIndividualSamples vecIndividualSamples, CDS_SignalBase* pOOSignal)
{
	CNDS_OpticalIndividualSamplesData SamplesOut;

	//Add each sampled signal to output data structures
	for (int i = 0; i < vecIndividualSamples.size(); i++)
	{
		SamplesOut.Add(vecIndividualSamples[i]);
	}
	COpticalIndividualSamplesArray* pSamplesOutput1;
	pSamplesOutput1 = ((CDS_OpticalSignal*)pOOSignal)->GetIndividualSamples();
	SamplesOut.GetData(pSamplesOutput1);


}



VECTOR_OpticalNoiseBins CDS_SystemManager::GetOpticalNoiseBinsVector(CDS_SignalBase* pSignalBase)
{
	VECTOR_OpticalNoiseBins returnBins;
	CNDS_OpticalNoiseBinsData NoiseBins(((CDS_OpticalSignal*)pSignalBase)->GetNoiseBins());
	CNDS_OpticalNoiseBin* pNoiseBins = NoiseBins.GetData();
	for (int i = 0; i < NoiseBins.GetSize(); i++)
	{
		returnBins.push_back(pNoiseBins[i]);
	}
	return returnBins;
}


void  CDS_SystemManager::PutOpticalNoiseBinsVector(VECTOR_OpticalNoiseBins vecNoiseBins, CDS_SignalBase* pOOSignal)
{
	CNDS_OpticalNoiseBinsData BinsOut;

	//Add each sampled signal to output data structures
	for (int i = 0; i < vecNoiseBins.size(); i++)
	{
		BinsOut.Add(vecNoiseBins[i]);
	}
	COpticalNoiseBinsArray* pBinsOut;
	pBinsOut = ((CDS_OpticalSignal*)pOOSignal)->GetNoiseBins();
	BinsOut.GetData(pBinsOut);


}



CNDS_ElectricalSampledSignal CDS_SystemManager::GetElectricalSampledSignal(CDS_SignalBase* pIOSignal1)
{
	CDS_ElectricalSignal* pInputPort1ElectricalSignal = (CDS_ElectricalSignal*)pIOSignal1;
	CNDS_ElectricalSampledSignal CNDS_ElectricalSampledSignal1(*(pInputPort1ElectricalSignal->GetSampledSignal()));
	return CNDS_ElectricalSampledSignal1;

}

void CDS_SystemManager::PutElectricalSampledSignal(CNDS_ElectricalSampledSignal sampledSignal, CDS_SignalBase* pOOSignal1)
{
	SElectricalSampledSignal sElectricalSignal1;
	sampledSignal.GetData(sElectricalSignal1);
	((CDS_ElectricalSignal*)pOOSignal1)->CopyFrom(&sElectricalSignal1);

}



CNDS_ElectricalSampledSignal CDS_SystemManager::GetElectricalSampledNoise(CDS_SignalBase* pIOSignal1)
{
	CDS_ElectricalSignal* pInputPort1ElectricalSignal = (CDS_ElectricalSignal*)pIOSignal1;
	CNDS_ElectricalSampledSignal ElectricalSampledNoise(*(pInputPort1ElectricalSignal->GetSampledNoise()));
	return ElectricalSampledNoise;
}

void CDS_SystemManager::PutElectricalSampledNoise(CNDS_ElectricalSampledSignal sampledNoise, CDS_SignalBase* pOOSignal1)
{
	SElectricalSampledSignal sElectricalNoise;
	sampledNoise.GetData(sElectricalNoise);
	((CDS_ElectricalSignal*)pOOSignal1)->CopyNoiseFrom(&sElectricalNoise);


}


CNDS_ElectricalIndividualSample CDS_SystemManager::GetElectricalIndividualSample(CDS_SignalBase* pIOSignal1)
{
	CDS_ElectricalSignal* pInputPort1ElectricalSignal = (CDS_ElectricalSignal*)pIOSignal1;
	CNDS_ElectricalIndividualSample individualSample(*(pInputPort1ElectricalSignal->GetIndividualSample()));
	return individualSample;

}

void CDS_SystemManager::PutElectricalIndividualSample(CNDS_ElectricalIndividualSample individualSample, CDS_SignalBase* pOOSignal1)
{
	SElectricalIndividualSample sIndividualSample;
	individualSample.GetData(sIndividualSample);
	((CDS_ElectricalSignal*)pOOSignal1)->CopyFrom(&sIndividualSample);

}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// convenience functions for user to access signals
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////





CDS_SystemManager::CDS_SystemManager()
{
	
}

CDS_SystemManager::CDS_SystemManager(CDS_SystemManager const&)
{

}
void CDS_SystemManager::operator=(CDS_SystemManager const&)
{


}

CDS_SystemManager* CDS_SystemManager::getInstance()
{
	if (!instanceFlag)
	{
		single = new CDS_SystemManager();
		instanceFlag = true;
		return single;
	}
	else
	{
		return single;
	}
}

CDS_SystemManager::~CDS_SystemManager()
{
	instanceFlag = false;
}

//For Internal use
CDS_SignalBase* CDS_SystemManager::GetSignalFromInputPort(long nInputPort)
{
	CDS_SignalBase* pOpticalSignal = NULL;
	std::map<long, CDS_SignalBase*>::iterator itI = m_mapInputPortSignal.find(nInputPort);

	if (itI != m_mapInputPortSignal.end())
	{
		//element found;
		pOpticalSignal = itI->second;

	}

	return pOpticalSignal;
}

CDS_SignalBase* CDS_SystemManager::GetSignalFromOutputPort(long nOutputPort)
{
	CDS_SignalBase* pOpticalSignal = NULL;
	std::map<long, CDS_SignalBase*>::iterator itO = m_mapOutputPortSignal.find(nOutputPort);

	if (itO != m_mapOutputPortSignal.end())
	{
		//element found;
		pOpticalSignal = itO->second;

	}

	return pOpticalSignal;
}

double CDS_SystemManager::GetGlobalParameterDouble(string strName)
{
	double dValue = 0;
	bool bRet = false;

	CDS_Parameter parameterG;
	bRet = m_ParameterMgr.GetGlobalParameterByName(strName, parameterG);

	if (bRet)
	{
		if (parameterG.GetParameterType() == CDS_Parameter::typeDouble)
		{
			dValue = parameterG.GetParameterDouble();
		}
	}

	return dValue;
}

double CDS_SystemManager::GetParameterDouble(string strName)
{
	double dValue = 0;
	bool bRet = false;

	CDS_Parameter parameterG;
	bRet = m_ParameterMgr.GetCppComponentParameterByName(strName, parameterG);

	if (bRet)
	{
		if (parameterG.GetParameterType() == CDS_Parameter::typeDouble)
		{
			dValue = parameterG.GetParameterDouble();
		}
	}

	return dValue;
}

string CDS_SystemManager::GetParameterString(string strName)
{

	string sValue = "";
	bool bRet = false;

	CDS_Parameter parameterG;
	bRet = m_ParameterMgr.GetCppComponentParameterByName(strName, parameterG);

	if (bRet)
	{
		if (parameterG.GetParameterType() == CDS_Parameter::typeString)
		{
			sValue = parameterG.GetParameterString();
		}
	}

	return sValue;

}

bool CDS_SystemManager::GetGlobalParameterBool(string strName)
{
	bool bRet = false;
	CDS_Parameter parameterG;
	bool bValue = 0;

	bRet = m_ParameterMgr.GetGlobalParameterByName(strName, parameterG);

	if (bRet)
	{
		if (parameterG.GetParameterType() == CDS_Parameter::typeBOOL)
		{
			bValue = parameterG.GetParameterBool();
		}
	}

	return bValue;
}

bool CDS_SystemManager::GetParameterBool(string strName)
{
	bool bRet = false;
	CDS_Parameter parameterG;
	bool bValue = 0;

	bRet = m_ParameterMgr.GetCppComponentParameterByName(strName, parameterG);

	if (bRet)
	{
		if (parameterG.GetParameterType() == CDS_Parameter::typeBOOL)
		{
			bValue = parameterG.GetParameterBool();
		}
	}

	return bValue;
}

long CDS_SystemManager::GetGlobalParameterLong(string strName)
{
	bool bRet = false;
	CDS_Parameter parameterG;
	long nValue = 0;

	bRet = m_ParameterMgr.GetGlobalParameterByName(strName, parameterG);

	if (bRet)
	{
		if (parameterG.GetParameterType() == CDS_Parameter::typeLong)
		{
			nValue = parameterG.GetParameterLong();
		}
	}

	return nValue;
}

long CDS_SystemManager::GetParameterLong(string strName)
{
	bool bRet = false;
	CDS_Parameter parameterG;
	long nValue = 0;

	bRet = m_ParameterMgr.GetCppComponentParameterByName(strName, parameterG);

	if (bRet)
	{
		if (parameterG.GetParameterType() == CDS_Parameter::typeLong)
		{
			nValue = parameterG.GetParameterLong();
		}
	}

	return nValue;
}

long CDS_SystemManager::GetNumberOfInputPorts()
{
	return m_mapInputPortSignal.size();
}

long CDS_SystemManager::GetNumberOfOutputPorts()
{
	return m_mapOutputPortSignal.size();	
}

long CDS_SystemManager::GetSignalTypeInputPort(long nInputPort)
{

	long nSignalType = 0;
	string sType;

	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;
		sType = pS->GetSignalName();

		if (sType == "OpticalSignal")
			nSignalType = typeOpticalSignal;
		else if (sType == "ElectricalSignal")
			nSignalType = typeElectricalSignal;
		else if (sType == "BinarySignal")
			nSignalType = typeBinarySignal;
		else if (sType == "MarySignal")
			nSignalType = typeMarySignal;

	}

	return nSignalType;
}

long CDS_SystemManager::GetSignalTypeOutputPort(long nOutputPort)
{
	
	long nSignalType = 0;
	string sType;

	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;
		sType = pS->GetSignalName();

		if (sType == "OpticalSignal")
			nSignalType = typeOpticalSignal;
		else if (sType == "ElectricalSignal")
			nSignalType = typeElectricalSignal;
		else if (sType == "BinarySignal")
			nSignalType = typeBinarySignal;
		else if (sType == "MarySignal")
			nSignalType = typeMarySignal;

	}

	return nSignalType;

}

string CDS_SystemManager::GetInputPortFileFolder(long nInputPort)
{

	string sFileFolder = "";

	std::map<long, string>::iterator it = m_mapInputPortFileNames.find(nInputPort);

	if (it != m_mapInputPortFileNames.end())
	{
		//element found;
		sFileFolder = it->second;
	}

	return sFileFolder;
}

string CDS_SystemManager::GetOutputPortFileFolder(long nOutputPort)
{
	string sFileFolder = "";

	std::map<long, string>::iterator it = m_mapOutputPortFileNames.find(nOutputPort);

	if (it != m_mapOutputPortFileNames.end())
	{
		//element found;
		sFileFolder = it->second;
	}

	return sFileFolder;
}

/////////////////////// Extrnal

void CDS_SystemManager::ResetArrayInputSignalPorts_API()
{
	
	mapPortSignal::iterator iS;
	CDS_SignalBase* pS;

	for (iS = m_mapInputPortSignal.begin(); iS != m_mapInputPortSignal.end(); ++iS)
	{
		pS = iS->second;
		delete pS;
	}

	m_mapInputPortSignal.clear();	

}

void CDS_SystemManager::ResetArrayOutputSignalPorts_API()
{	

	mapPortSignal::iterator ipS;	
	CDS_SignalBase* pS;

	for (ipS = m_mapOutputPortSignal.begin(); ipS != m_mapOutputPortSignal.end(); ++ipS)
	{
		pS = ipS->second;
		delete pS;
	}

	m_mapOutputPortSignal.clear();
			
}

void CDS_SystemManager::AddSignalToInputPortArray_API(long nInputPort, long nSignalType)
{
	if (nSignalType == typeOpticalSignal)
	{
		CDS_OpticalSignal* pOpticalSignal = new CDS_OpticalSignal;
		m_mapInputPortSignal.insert(std::pair<long, CDS_SignalBase*>(nInputPort, (CDS_SignalBase*)pOpticalSignal));		
	}
	else if (nSignalType == typeElectricalSignal)
	{		
		CDS_ElectricalSignal* pElectricalSignal = new CDS_ElectricalSignal;
		m_mapInputPortSignal.insert(std::pair<long, CDS_SignalBase*>(nInputPort, (CDS_SignalBase*)pElectricalSignal));
	}
	else if (nSignalType == typeBinarySignal)
	{
		CDS_BinarySignal* pBinarySignal = new CDS_BinarySignal;
		m_mapInputPortSignal.insert(std::pair<long, CDS_SignalBase*>(nInputPort, (CDS_SignalBase*)pBinarySignal));
	}
	else if (nSignalType == typeMarySignal)
	{		
		CDS_MarySignal* pMarySignal = new CDS_MarySignal;
		m_mapInputPortSignal.insert(std::pair<long, CDS_SignalBase*>(nInputPort, (CDS_SignalBase*)pMarySignal));
	}		
}

void CDS_SystemManager::AddSignalToOutputPortArray_API(long nOutputPort, long nSignalType)
{
	if (nSignalType == typeOpticalSignal)
	{		
		CDS_OpticalSignal* pOpticalSignal = new CDS_OpticalSignal;
		m_mapOutputPortSignal.insert(std::pair<long, CDS_SignalBase*>(nOutputPort, (CDS_SignalBase*)pOpticalSignal));		
	}
	else if (nSignalType == typeElectricalSignal)
	{
		CDS_ElectricalSignal* pElectricalSignal = new CDS_ElectricalSignal;
		m_mapOutputPortSignal.insert(std::pair<long, CDS_SignalBase*>(nOutputPort, (CDS_SignalBase*)pElectricalSignal));
	}
	else if (nSignalType == typeBinarySignal)
	{		
		CDS_BinarySignal* pBinarySignal = new CDS_BinarySignal;
		m_mapOutputPortSignal.insert(std::pair<long, CDS_SignalBase*>(nOutputPort, (CDS_SignalBase*)pBinarySignal));
	}
	else if (nSignalType == typeMarySignal)
	{		
		CDS_MarySignal* pMarySignal = new CDS_MarySignal;
		m_mapOutputPortSignal.insert(std::pair<long, CDS_SignalBase*>(nOutputPort, (CDS_SignalBase*)pMarySignal));
	}
	
}

void CDS_SystemManager::PutBinarySignal_API(long nInputPort, LONGVECTOR& rarrBits, double dBitRate)
{
	
	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "BinarySignal")
		{
			long nSize = rarrBits.size();
			((CDS_BinarySignal*)pS)->m_Bits.resize(nSize);
				
			for (int i = 0; i<nSize; i++)
				((CDS_BinarySignal*)pS)->m_Bits[i] = rarrBits[i];

			((CDS_BinarySignal*)pS)->m_dBitRate = dBitRate;

		}
	}

}

bool CDS_SystemManager::GetBinarySignal_API(long nOutputPort, LONGVECTOR& rarrBits, double& dBitRate)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "BinarySignal")
		{
				//fill rarrBits and dBitRate
			dBitRate = ((CDS_BinarySignal*)pS)->GetBitRate();

			rarrBits.resize(((CDS_BinarySignal*)pS)->GetBits()->size());

			for (int i = 0; i < ((CDS_BinarySignal*)pS)->GetBits()->size(); i++)
				rarrBits[i] = ((CDS_BinarySignal*)pS)->GetBits()->at(i);

			return true;
		}
	}

	return false;
}

void CDS_SystemManager::PutMarySignal_API(long nInputPort, DOUBLEVECTOR& rarrSymbols, double dSymbolRate)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "MarySignal")
		{
			long nSize = rarrSymbols.size();
			((CDS_MarySignal*)pS)->m_Symbols.resize(nSize);

			for (int i = 0; i < nSize; i++)
				((CDS_MarySignal*)pS)->m_Symbols[i] = rarrSymbols[i];

			((CDS_MarySignal*)pS)->m_dSymbolRate = dSymbolRate;

		}
	}
}

bool CDS_SystemManager::GetMarySignal_API(long nOutputPort, DOUBLEVECTOR& rarrSymbols, double& dSymbolRate)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "MarySignal")
		{
			//fill rarrBits and dBitRate
			dSymbolRate = ((CDS_MarySignal*)pS)->GetSymbolRate();

			rarrSymbols.resize(((CDS_MarySignal*)pS)->GetSymbols()->size());

			for (int i = 0; i < ((CDS_MarySignal*)pS)->GetSymbols()->size(); i++)
				rarrSymbols[i] = ((CDS_MarySignal*)pS)->GetSymbols()->at(i);

			return true;
		}
	}

	return false;
}

//Put the electrical sampled signal structure.
void CDS_SystemManager::PutElectricalSampledSignal_API(long nInputPort, CComplex* pccE, long nSize, double dSampleRate)
{
		
	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "ElectricalSignal")
		{
			SElectricalSampledSignal pSElectricalSampledSignal;

			pSElectricalSampledSignal.m_arrAmplitude.resize(nSize);

			for (int i = 0; i < nSize; i++)
				pSElectricalSampledSignal.m_arrAmplitude[i] = pccE[i];

			pSElectricalSampledSignal.m_dSampleRate = dSampleRate;

			((CDS_ElectricalSignal*)pS)->CopyFrom(&pSElectricalSampledSignal);
			
		}
	}

}
void CDS_SystemManager::GetElectricalSampledSignalSize_API(long nOutputPort, long& nSize)
{
	nSize = 0;	
	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "ElectricalSignal")
		{
			SElectricalSampledSignal* pSElectricalSampledSignal = ((CDS_ElectricalSignal*)pS)->GetSampledSignal();

			if (pSElectricalSampledSignal != NULL)
				nSize = pSElectricalSampledSignal->m_arrAmplitude.size();

		}
	}

}

void CDS_SystemManager::GetElectricalSampledSignal_API(long nOutputPort, COMPLEXVECTOR& pccE, double& dSampleRate)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "ElectricalSignal")
		{
			SElectricalSampledSignal* pSElectricalSampledSignal = ((CDS_ElectricalSignal*)pS)->GetSampledSignal();

			if (pSElectricalSampledSignal)
			{

				long nSizeSampled = pSElectricalSampledSignal->m_arrAmplitude.size();
				pccE.resize(nSizeSampled);

				for (int i = 0; i < pSElectricalSampledSignal->m_arrAmplitude.size(); i++)
					pccE[i] = pSElectricalSampledSignal->m_arrAmplitude.at(i);

				dSampleRate = pSElectricalSampledSignal->m_dSampleRate;

			}
		}
	}

}

void CDS_SystemManager::PutElectricalIndividualSampledSignal_API(long nInputPort, CComplex* pccE, long nSize, double dSampleRate)
{

	
	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "ElectricalSignal")
		{
			SElectricalIndividualSample pSElectricalIndSampledSignal;

			pSElectricalIndSampledSignal.m_dSampleRate = dSampleRate;

			if (nSize == 1)
				pSElectricalIndSampledSignal.m_ccAmplitude = pccE[0];

			((CDS_ElectricalSignal*)pS)->CopyFrom(&pSElectricalIndSampledSignal);

		}
	}

}

void CDS_SystemManager::GetElectricalIndividualSampledSignal_API(long nOutputPort, COMPLEXVECTOR& pccE, double& dSampleRate)
{	

	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "ElectricalSignal")
		{
			SElectricalIndividualSample* pSElectricalIndSampledSignal = ((CDS_ElectricalSignal*)pS)->GetIndividualSample();

			if (pSElectricalIndSampledSignal != NULL)
			{
				pccE.resize(1);

				pccE[0] = pSElectricalIndSampledSignal->m_ccAmplitude;

				dSampleRate = pSElectricalIndSampledSignal->m_dSampleRate;

			}
		}
	}

}

void CDS_SystemManager::PutElectricalSampledNoiseSignal_API(long nInputPort, CComplex* pccE, long nSize, double dSampleRate)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "ElectricalSignal")
		{
			SElectricalSampledSignal pSElectricalSampledNoiseSignal;

			pSElectricalSampledNoiseSignal.m_arrAmplitude.resize(nSize);

			for (int i = 0; i < nSize; i++)
				pSElectricalSampledNoiseSignal.m_arrAmplitude[i] = pccE[i];

			pSElectricalSampledNoiseSignal.m_dSampleRate = dSampleRate;

			((CDS_ElectricalSignal*)pS)->CopyNoiseFrom(&pSElectricalSampledNoiseSignal);

		}
	}

}

void CDS_SystemManager::GetElectricalSampledNoiseSignalSize_API(long nOutputPort, long& nSize)
{
	nSize = 0;

	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "ElectricalSignal")
		{
			SElectricalSampledSignal* pSElectricalSampledNoiseSignal = ((CDS_ElectricalSignal*)pS)->GetSampledNoise();

			if (pSElectricalSampledNoiseSignal != NULL)
			{
				if (pSElectricalSampledNoiseSignal != NULL)
					nSize = pSElectricalSampledNoiseSignal->m_arrAmplitude.size();
			}
		}
	}

}

void CDS_SystemManager::GetElectricalSampledNoiseSignal_API(long nOutputPort, COMPLEXVECTOR& pccE, /* DOUBLEVECTOR &pccFreq,*/ double& dSampleRate)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "ElectricalSignal")
		{
			SElectricalSampledSignal* pSElectricalSampledNoiseSignal = ((CDS_ElectricalSignal*)pS)->GetSampledNoise();

			if (pSElectricalSampledNoiseSignal != NULL)
			{

				long nSizeSampled = pSElectricalSampledNoiseSignal->m_arrAmplitude.size();

				pccE.resize(nSizeSampled);

				for (int i = 0; i < nSizeSampled; i++)
					pccE[i] = pSElectricalSampledNoiseSignal->m_arrAmplitude.at(i);

				dSampleRate = pSElectricalSampledNoiseSignal->m_dSampleRate;

			}
		}
	}

}

void CDS_SystemManager::PutElectricalSampledNoiseArray_API(long nInputPort, COMPLEXVECTORS& pccE, COMPLEXVECTORS& pccNormalizedPSD, DOUBLEVECTOR& vecSampleRate)
{
	
	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "ElectricalSignal")
		{
			long nNoiseSize = pccE.size();
			CElectricalSampledNoiseArray    arrData;

			for (int i = 0; i < nNoiseSize; i++)
			{
				SElectricalSampledNoise structElectricalSampledNoise;
				COMPLEXVECTOR arrAmpl = pccE[i];
				COMPLEXVECTOR pccNorm = pccNormalizedPSD[i];
				double dSampleRate = vecSampleRate[i];

				structElectricalSampledNoise.m_arrAmplitude = arrAmpl;
				structElectricalSampledNoise.m_arrNormalizedPSD = pccNorm;
				structElectricalSampledNoise.m_dSampleRate = dSampleRate;
				arrData.push_back(structElectricalSampledNoise);
			}

			((CDS_ElectricalSignal*)pS)->CopyFrom(&arrData);

		}
	}

}

void CDS_SystemManager::GetElectricalSampledNoiseArray_API(long nOutputPort, COMPLEXVECTORS& pccE, COMPLEXVECTORS& pccNormalizedPSD, DOUBLEVECTOR& vecSampleRate)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "ElectricalSignal")
		{

			CElectricalSampledNoiseArray* pSElectricalSampledNoise = ((CDS_ElectricalSignal*)pS)->GetNoise();

			pccE.resize(pSElectricalSampledNoise->size());
			pccNormalizedPSD.resize(pSElectricalSampledNoise->size());
			vecSampleRate.resize(pSElectricalSampledNoise->size());

			for (int i = 0; i < pSElectricalSampledNoise->size(); i++)
			{
				SElectricalSampledNoise structElectricalSampledNoise = pSElectricalSampledNoise->at(i);
				pccE[i] = structElectricalSampledNoise.m_arrAmplitude;
				pccNormalizedPSD[i] = structElectricalSampledNoise.m_arrNormalizedPSD;
				vecSampleRate[i] = structElectricalSampledNoise.m_dSampleRate;

			}
		}
	}
}

void CDS_SystemManager::GetElectricalSampledNoiseArraySize_API(long nOutputPort, long& nSize)
{
	nSize = 0;
	
	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "ElectricalSignal")
		{

			CElectricalSampledNoiseArray* pSElectricalSampledNoise = ((CDS_ElectricalSignal*)pS)->GetNoise();
			nSize = pSElectricalSampledNoise->size();
		}

	}

}

void CDS_SystemManager::AddParameterBOOL_API(string sName, bool bValueBool, bool bCppComponent)
{	
	CDS_Parameter parBOOL;

	parBOOL.SetParameterName(sName);
	
	parBOOL.SetParameterType(CDS_Parameter::typeBOOL);
	parBOOL.SetParameterBool(bValueBool);

	if (bCppComponent)
		m_ParameterMgr.AddCppComponentParameter(sName, parBOOL);
	else
		m_ParameterMgr.AddGlobalParameter(sName, parBOOL);

}

void CDS_SystemManager::AddParameterLONG_API(string sName, long bValueLong, string sUnit, long nMin, long nMax, bool bCppComponent)
{
	CDS_Parameter parLONG;

	parLONG.SetParameterName(sName);
	parLONG.SetParameterType(CDS_Parameter::typeLong);
	parLONG.SetParameterUnit(sUnit);
	parLONG.SetParameterLong(bValueLong);
	parLONG.SetParameterMinMax(nMin, nMax);

	if (bCppComponent)
		m_ParameterMgr.AddCppComponentParameter(sName, parLONG);
	else
		m_ParameterMgr.AddGlobalParameter(sName, parLONG);

}

void CDS_SystemManager::AddParameterSTRING_API(string sName, string sValueString, bool bFilename, bool bCppComponent)
{
	CDS_Parameter parSTRING;

	parSTRING.SetParameterName(sName);
	parSTRING.SetParameterType(CDS_Parameter::typeString);
	parSTRING.SetParameterString(sValueString, bFilename);

	if (bCppComponent)
		m_ParameterMgr.AddCppComponentParameter(sName, parSTRING);
	else
		m_ParameterMgr.AddGlobalParameter(sName, parSTRING);

}

void CDS_SystemManager::AddParameterDOUBLE_API(string sName, double dValueDouble, string sUnit, double dMin, double dMax, bool bCppComponent)
{
	CDS_Parameter parDOUBLE;

	parDOUBLE.SetParameterName(sName);
	parDOUBLE.SetParameterType(CDS_Parameter::typeDouble);
	parDOUBLE.SetParameterDouble(dValueDouble);
	parDOUBLE.SetParameterUnit(sUnit);
	parDOUBLE.SetParameterMinMax(dMin, dMax);

	if (bCppComponent)
		m_ParameterMgr.AddCppComponentParameter(sName, parDOUBLE);
	else
		m_ParameterMgr.AddGlobalParameter(sName, parDOUBLE);

}

void CDS_SystemManager::AddParameterCHOICE_API(string sName, string sChoice, string sChoiceList, bool bCppComponent)
{
	CDS_Parameter parCHOICE;

	parCHOICE.SetParameterName(sName);
	parCHOICE.SetParameterType(CDS_Parameter::typeChoice);
	parCHOICE.SetParameterChoiceList(sChoiceList);
	parCHOICE.SetParameterChoice(sChoice);

	if (bCppComponent)
		m_ParameterMgr.AddCppComponentParameter(sName, parCHOICE);
	else
		m_ParameterMgr.AddGlobalParameter(sName, parCHOICE);

}

void CDS_SystemManager::ClearAllParameters_API()
{

	m_ParameterMgr.RemoveAllGlobalParameters();
	m_ParameterMgr.RemoveAllCppComponentParameters();

}

void CDS_SystemManager::SetGlobalFrequencyGridSpacing_API(double dFrequencyGridSpacing)
{
	CGlobalFrequencyGrid::SetFrequencyGridSpacing(dFrequencyGridSpacing);
}

void CDS_SystemManager::SetGlobalNoiseBinResolution_API(long nNoiseBinResolution)
{
	CGlobalFrequencyGrid::SetNoiseBinResolution(nNoiseBinResolution);
}

void CDS_SystemManager::SetGlobalGridSpacingX_API(double dGridSpacing)
{
	CGlobalSpaceGrid::SetGridSpacingX(dGridSpacing);
}

void CDS_SystemManager::SetGlobalGridSpacingY_API(double dGridSpacing)
{
	CGlobalSpaceGrid::SetGridSpacingY(dGridSpacing);
}

void CDS_SystemManager::SetOpticalSignalFrequencyGrid_API(long nInputPort, double dFrequencyGridSpacing, double dGridSpacingX, double dGridSpacingY)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "OpticalSignal")
		{

			((CDS_OpticalSignal*)pS)->SetFrequencyGridSpacing(dFrequencyGridSpacing);
			((CDS_OpticalSignal*)pS)->SetGridSpacingX(dGridSpacingX);
			((CDS_OpticalSignal*)pS)->SetGridSpacingY(dGridSpacingY);
		}
	}
	
}

void CDS_SystemManager::PutOpticalIndividualSamples_API(long nInputPort, COMPLEXVECTOR& pccAmpX, COMPLEXVECTOR& pccAmpY, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "OpticalSignal")
		{
			long nIndvSmplsSize = pccAmpX.size();
			COpticalIndividualSamplesArray    arrData;

			arrData.resize(0);

			for (int i = 0; i < nIndvSmplsSize; i++)
			{
				SOpticalIndividualSample structOpticalIndividualSample;

				CComplex	cAmplitudeX = pccAmpX[i];
				CComplex	cAmplitudeY = pccAmpY[i];

				double dLowerFreq = pccLowerFreq[i];
				double dUpperFreq = pccUpperFreq[i];

				structOpticalIndividualSample.m_Bandwidth.m_dLowerFrequency = dLowerFreq;
				structOpticalIndividualSample.m_Bandwidth.m_dUpperFrequency = dUpperFreq;

				structOpticalIndividualSample.m_ccAmplitudeX = cAmplitudeX;
				structOpticalIndividualSample.m_ccAmplitudeY = cAmplitudeY;

				arrData.push_back(structOpticalIndividualSample);
			}

			((CDS_OpticalSignal*)pS)->CopyFrom(&arrData);

		}
	}
	
}

void CDS_SystemManager::GetOpticalIndividualSamples_API(long nOutputPort, COMPLEXVECTOR& pccAmpX, COMPLEXVECTOR& pccAmpY, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq)
{
	
	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "OpticalSignal")
		{
			if (((CDS_OpticalSignal*)pS)->IsIndividualSamples())
			{

				COpticalIndividualSamplesArray*  pOpticalIndividualSamplesArray = ((CDS_OpticalSignal*)pS)->GetIndividualSamples();
				long nIndvSmplsSize = pOpticalIndividualSamplesArray->size();

				pccAmpX.resize(nIndvSmplsSize);
				pccAmpY.resize(nIndvSmplsSize);
				pccLowerFreq.resize(nIndvSmplsSize);
				pccUpperFreq.resize(nIndvSmplsSize);

				for (int i = 0; i < nIndvSmplsSize; i++)
				{
					SOpticalIndividualSample structOpticalIndividualSample = pOpticalIndividualSamplesArray->at(i);

					pccAmpX[i] = structOpticalIndividualSample.m_ccAmplitudeX;
					pccAmpY[i] = structOpticalIndividualSample.m_ccAmplitudeY;
					pccLowerFreq[i] = structOpticalIndividualSample.m_Bandwidth.m_dLowerFrequency;
					pccUpperFreq[i] = structOpticalIndividualSample.m_Bandwidth.m_dUpperFrequency;

				}
			}
		}
	}
}

void CDS_SystemManager::PutOpticalNoise_API(long nInputPort, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq, DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "OpticalSignal")
		{
			long nNoiseSize = pccLowerFreq.size();
			COpticalNoiseBinsArray    arrData;

			arrData.resize(0);

			for (int i = 0; i < nNoiseSize; i++)
			{
				SOpticalNoiseBin structOpticalNoise;

				double dLowerFreq = pccLowerFreq[i];
				double dUpperFreq = pccUpperFreq[i];

				double dPower = pccPower[i];
				double dSplittingRatio = pccSplittingRatio[i];
				double dPhaseDifference = pccPhaseDifference[i];

				structOpticalNoise.m_Bandwidth.m_dLowerFrequency = dLowerFreq;
				structOpticalNoise.m_Bandwidth.m_dUpperFrequency = dUpperFreq;

				structOpticalNoise.m_Polarization.Set(dPower, dSplittingRatio, dPhaseDifference);

				arrData.push_back(structOpticalNoise);
			}

			((CDS_OpticalSignal*)pS)->CopyFrom(&arrData);
		}
	}
	
}

void CDS_SystemManager::GetOpticalNoise_API(long nOutputPort, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq, DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference)
{
	
	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "OpticalSignal")
		{
			if (((CDS_OpticalSignal*)pS)->IsNoiseBins())
			{
				COpticalNoiseBinsArray* pOpticalNoiseBinsArray = ((CDS_OpticalSignal*)pS)->GetNoiseBins();
				long nNoiseSize = pOpticalNoiseBinsArray->size();

				pccLowerFreq.resize(nNoiseSize);
				pccUpperFreq.resize(nNoiseSize);
				pccPower.resize(nNoiseSize);
				pccSplittingRatio.resize(nNoiseSize);
				pccPhaseDifference.resize(nNoiseSize);

				for (int i = 0; i < nNoiseSize; i++)
				{
					SOpticalNoiseBin structOpticalNoise = pOpticalNoiseBinsArray->at(i);

					pccLowerFreq[i] = structOpticalNoise.m_Bandwidth.m_dLowerFrequency;
					pccUpperFreq[i] = structOpticalNoise.m_Bandwidth.m_dUpperFrequency;
					pccPower[i] = structOpticalNoise.m_Polarization.GetPower();
					pccSplittingRatio[i] = structOpticalNoise.m_Polarization.GetSplittingRatio();
					pccPhaseDifference[i] = structOpticalNoise.m_Polarization.GetPhaseDifference();

				}
			}

		}
	}
}

void CDS_SystemManager::PutOpticalParameterized_API(long nInputPort, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq, DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "OpticalSignal")
		{
			long nParameterizedSize = pccLowerFreq.size();
			COpticalParameterizedSignalsArray    arrData;

			arrData.resize(0);

			for (int i = 0; i < nParameterizedSize; i++)
			{
				SOpticalParameterizedSignal structOpticalParameterized;

				double dLowerFreq = pccLowerFreq[i];
				double dUpperFreq = pccUpperFreq[i];

				double dPower = pccPower[i];
				double dSplittingRatio = pccSplittingRatio[i];
				double dPhaseDifference = pccPhaseDifference[i];

				structOpticalParameterized.m_Bandwidth.m_dLowerFrequency = dLowerFreq;
				structOpticalParameterized.m_Bandwidth.m_dUpperFrequency = dUpperFreq;

				structOpticalParameterized.m_Polarization.Set(dPower, dSplittingRatio, dPhaseDifference);

				arrData.push_back(structOpticalParameterized);
			}

			((CDS_OpticalSignal*)pS)->CopyFrom(&arrData);
		}
	}		
}

void CDS_SystemManager::GetOpticalParameterized_API(long nOutputPort, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq, DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "OpticalSignal")
		{
			if (((CDS_OpticalSignal*)pS)->IsParameterized())
			{
				COpticalParameterizedSignalsArray* pOpticalParameterizedSignalsArray = ((CDS_OpticalSignal*)pS)->GetParameterizedSignals();
				long nParameterizedSize = pOpticalParameterizedSignalsArray->size();

				pccLowerFreq.resize(nParameterizedSize);
				pccUpperFreq.resize(nParameterizedSize);
				pccPower.resize(nParameterizedSize);
				pccSplittingRatio.resize(nParameterizedSize);
				pccPhaseDifference.resize(nParameterizedSize);

				for (int i = 0; i < nParameterizedSize; i++)
				{
					SOpticalParameterizedSignal structOpticalParameterized = pOpticalParameterizedSignalsArray->at(i);

					pccLowerFreq[i] = structOpticalParameterized.m_Bandwidth.m_dLowerFrequency;
					pccUpperFreq[i] = structOpticalParameterized.m_Bandwidth.m_dUpperFrequency;
					pccPower[i] = structOpticalParameterized.m_Polarization.GetPower();
					pccSplittingRatio[i] = structOpticalParameterized.m_Polarization.GetSplittingRatio();
					pccPhaseDifference[i] = structOpticalParameterized.m_Polarization.GetPhaseDifference();

				}
			}
		}
	}
}

void CDS_SystemManager::SetOpticalChannels_API(long nInputPort, DOUBLEVECTOR& pccChannels)
{	
	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "OpticalSignal")
		{
			((CDS_OpticalSignal*)pS)->AddChannels(pccChannels);
		}
	}		
}

void CDS_SystemManager::GetOpticalChannels_API(long nOutputPort, DOUBLEVECTOR& pccChannels)
{
	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "OpticalSignal")
		{
			DOUBLEVECTOR* pChannels = ((CDS_OpticalSignal*)pS)->GetChannels();
			long nSizeChannels = pChannels->size();

			pccChannels.resize(nSizeChannels);
			for (int i = 0; i < nSizeChannels; i++)
			{
				pccChannels[i] = pChannels->at(i);
			}
		}
	}
}

void CDS_SystemManager::PutOpticalSampled_API(long nInputPort, LONGVECTOR& pccTotalField,
	DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq,
	COMPLEXVECTORS& pccAmplX, COMPLEXVECTORS& pccAmplY,
	DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference,
	COMPLEXVECTORS& pccModeX, LONGVECTOR& pccMXsizeX, LONGVECTOR& pccMXsizeY,
	COMPLEXVECTORS& pccModeY, LONGVECTOR& pccMYsizeX, LONGVECTOR& pccMYsizeY,
	STRINGVECTOR& pccModePropX, STRINGVECTOR& pccModePropY,
	DOUBLEVECTOR& pccPhaseDelayX, DOUBLEVECTOR& pccPhaseDelayY)
{

	//std::fstream fs;
	//fs.open("c:\\TEMP\\PutOpticalSampled.txt", std::fstream::in | std::fstream::out | std::fstream::app);

	std::map<long, CDS_SignalBase*>::iterator it = m_mapInputPortSignal.find(nInputPort);
	CDS_SignalBase* pS;

	if (it != m_mapInputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "OpticalSignal")
		{
			long nSampledSize = pccTotalField.size();
			COpticalSampledSignalsArray    arrData;

			arrData.resize(0);

			for (int i = 0; i < nSampledSize; i++)
			{

				SOpticalSampledSignal structOpticalSampledSignal;

				structOpticalSampledSignal.m_bTotalField = pccTotalField[i];

				// BANDWIDTH
				double dLowerFreq = pccLowerFreq[i];
				double dUpperFreq = pccUpperFreq[i];

				structOpticalSampledSignal.m_Bandwidth.m_dLowerFrequency = dLowerFreq;
				structOpticalSampledSignal.m_Bandwidth.m_dUpperFrequency = dUpperFreq;


				double dPower = pccPower[i];
				double dSplittingRatio = pccSplittingRatio[i];
				double dPhaseDifference = pccPhaseDifference[i];

				structOpticalSampledSignal.m_Polarization.Set(dPower, dSplittingRatio, dPhaseDifference);

				COMPLEXVECTOR arrAmplX = pccAmplX[i];
				COMPLEXVECTOR arrAmplY = pccAmplY[i];

				structOpticalSampledSignal.m_arrAmplitudeX = arrAmplX;
				structOpticalSampledSignal.m_arrAmplitudeY = arrAmplY;

				for (int i = 0; i < structOpticalSampledSignal.m_arrAmplitudeX.size(); i++)
				{
					CComplex cmp = structOpticalSampledSignal.m_arrAmplitudeX[i];
						//fs << real(cmp);
						//fs << imag(cmp);				

				}

				COMPLEXVECTOR arrModeX = pccModeX[i];
				structOpticalSampledSignal.m_arrModeX = arrModeX;

				COMPLEXVECTOR arrModeY = pccModeY[i];
				structOpticalSampledSignal.m_arrModeY = arrModeY;

				//MeshX
				long nMeshXSizeX = pccMXsizeX[i];
				long nMeshXSizeY = pccMXsizeY[i];

				structOpticalSampledSignal.m_MeshX.m_nSizeX = nMeshXSizeX;
				structOpticalSampledSignal.m_MeshX.m_nSizeY = nMeshXSizeY;

				//MeshY
				long nMeshYSizeX = pccMYsizeX[i];
				long nMeshYSizeY = pccMYsizeY[i];

				structOpticalSampledSignal.m_MeshY.m_nSizeX = nMeshYSizeX;
				structOpticalSampledSignal.m_MeshY.m_nSizeY = nMeshYSizeY;

				string sModePropertiesX = pccModePropX[i];
				string sModePropertiesY = pccModePropY[i];

				structOpticalSampledSignal.m_sModePropertiesX = sModePropertiesX;
				structOpticalSampledSignal.m_sModePropertiesY = sModePropertiesY;

				double dPhaseDelayX = pccPhaseDelayX[i];
				double dPhaseDelayY = pccPhaseDelayY[i];

				structOpticalSampledSignal.m_dPhaseDelayX = dPhaseDelayX;
				structOpticalSampledSignal.m_dPhaseDelayY = dPhaseDelayY;

				arrData.push_back(structOpticalSampledSignal);

			}

			((CDS_OpticalSignal*)pS)->CopyFrom(&arrData);
		}
	}

	//fs.close();
}

void CDS_SystemManager::GetOpticalSampled_API(long nOutputPort, LONGVECTOR& pccTotalField,
	DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq,
	COMPLEXVECTORS& pccAmplX, COMPLEXVECTORS& pccAmplY,
	DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference,
	COMPLEXVECTORS& pccModeX, LONGVECTOR& pccMXsizeX, LONGVECTOR& pccMXsizeY,
	COMPLEXVECTORS& pccModeY, LONGVECTOR& pccMYsizeX, LONGVECTOR& pccMYsizeY,
	STRINGVECTOR& pccModePropX, STRINGVECTOR& pccModePropY,
	DOUBLEVECTOR& pccPhaseDelayX, DOUBLEVECTOR& pccPhaseDelayY)
{

	std::map<long, CDS_SignalBase*>::iterator it = m_mapOutputPortSignal.find(nOutputPort);
	CDS_SignalBase* pS;

	if (it != m_mapOutputPortSignal.end())
	{
		//element found;
		pS = it->second;

		if (pS->GetSignalName() == "OpticalSignal")
		{
			if (((CDS_OpticalSignal*)pS)->IsSampledSignals())
			{
				COpticalSampledSignalsArray* pOpticalSampledSignalsArray = ((CDS_OpticalSignal*)pS)->GetSampledSignals();

				long nSampledSize = pOpticalSampledSignalsArray->size();

				pccTotalField.resize(nSampledSize);
				pccLowerFreq.resize(nSampledSize);
				pccUpperFreq.resize(nSampledSize);
				pccAmplX.resize(nSampledSize);
				pccAmplY.resize(nSampledSize);
				pccPower.resize(nSampledSize);
				pccSplittingRatio.resize(nSampledSize);
				pccPhaseDifference.resize(nSampledSize);
				pccModeX.resize(nSampledSize);
				pccMXsizeX.resize(nSampledSize);
				pccMXsizeY.resize(nSampledSize);
				pccModeY.resize(nSampledSize);
				pccMYsizeX.resize(nSampledSize);
				pccMYsizeY.resize(nSampledSize);
				pccModePropX.resize(nSampledSize);
				pccModePropY.resize(nSampledSize);
				pccPhaseDelayX.resize(nSampledSize);
				pccPhaseDelayY.resize(nSampledSize);


				for (int i = 0; i < nSampledSize; i++)
				{
					SOpticalSampledSignal structOpticalSampledSignal = pOpticalSampledSignalsArray->at(i);

					pccTotalField[i] = structOpticalSampledSignal.m_bTotalField;
					pccLowerFreq[i] = structOpticalSampledSignal.m_Bandwidth.m_dLowerFrequency;
					pccUpperFreq[i] = structOpticalSampledSignal.m_Bandwidth.m_dUpperFrequency;

					long nSizeAmplX = structOpticalSampledSignal.m_arrAmplitudeX.size();

					pccAmplX[i].resize(nSizeAmplX);

					for (int j = 0; j < nSizeAmplX; j++)
					{
						pccAmplX[i][j] = structOpticalSampledSignal.m_arrAmplitudeX[j];
					}

					long nSizeAmplY = structOpticalSampledSignal.m_arrAmplitudeY.size();
					pccAmplY[i].resize(nSizeAmplY);

					for (int j = 0; j < nSizeAmplY; j++)
					{
						pccAmplY[i][j] = structOpticalSampledSignal.m_arrAmplitudeY[j];
					}


					pccPower[i] = structOpticalSampledSignal.m_Polarization.GetPower();
					pccSplittingRatio[i] = structOpticalSampledSignal.m_Polarization.GetSplittingRatio();
					pccPhaseDifference[i] = structOpticalSampledSignal.m_Polarization.GetPhaseDifference();

					pccModeX[i].resize(0);
					if (structOpticalSampledSignal.m_arrModeX.size() > 0)
					{
						long nSizeModeX = structOpticalSampledSignal.m_arrModeX.size();
						pccModeX[i].resize(nSizeModeX);

						pccMXsizeX[i] = structOpticalSampledSignal.m_MeshX.m_nSizeX;
						pccMXsizeY[i] = structOpticalSampledSignal.m_MeshX.m_nSizeY;
						pccModePropX[i] = structOpticalSampledSignal.m_sModePropertiesX;
						pccPhaseDelayX[i] = structOpticalSampledSignal.m_dPhaseDelayX;

						for (int j = 0; j < nSizeModeX; j++)
						{
							pccModeX[i][j] = structOpticalSampledSignal.m_arrModeX[j];
						}
					}

					pccModeY[i].resize(0);
					if (structOpticalSampledSignal.m_arrModeY.size() > 0)
					{
						long nSizeModeY = structOpticalSampledSignal.m_arrModeY.size();
						pccModeY[i].resize(nSizeModeY);

						pccMYsizeX[i] = structOpticalSampledSignal.m_MeshY.m_nSizeX;
						pccMYsizeY[i] = structOpticalSampledSignal.m_MeshY.m_nSizeY;
						pccModePropY[i] = structOpticalSampledSignal.m_sModePropertiesY;
						pccPhaseDelayY[i] = structOpticalSampledSignal.m_dPhaseDelayY;

						for (int j = 0; j < nSizeModeY; j++)
						{
							pccModeY[i][j] = structOpticalSampledSignal.m_arrModeY[j];
						}

					}

				}

			}

		}
	}
}

void CDS_SystemManager::AddResult(string sResultName, double dValue)
{
	m_mapResults.insert(std::pair<string, double>(sResultName, dValue));
}

void CDS_SystemManager::Allocate2DGraph(string sGraphName)
{
	CDS_2DGraph* pGraph = new CDS_2DGraph();

	m_map2DGraphs.insert(std::pair<string, CDS_2DGraph*>(sGraphName, pGraph));

}

CDS_2DGraph* CDS_SystemManager::Get2DGraph(string sGraphName)
{
	std::map<string, CDS_2DGraph*>::iterator it = m_map2DGraphs.find(sGraphName);
	CDS_2DGraph* p2DGraph = NULL;

	if (it != m_map2DGraphs.end())
	{
		//element found;
		p2DGraph = it->second;
	}

	return p2DGraph;

}

void CDS_SystemManager::RemoveAllGraphs()
{

	map2DGraphs::iterator it;
	CDS_2DGraph* p2DGraph;

	for (it = m_map2DGraphs.begin(); it != m_map2DGraphs.end(); ++it)
	{
		p2DGraph = it->second;
		delete p2DGraph;
	}

	m_map2DGraphs.clear();

}

void CDS_SystemManager::ClearAllResults()
{
	m_mapResults.clear();
}

void CDS_SystemManager::ClearAllInputPortFileNames()
{
	m_mapInputPortFileNames.clear();
}

void CDS_SystemManager::ClearAllOutputPortFileNames()
{
	m_mapOutputPortFileNames.clear();
}

void CDS_SystemManager::AddInputPortFileName( long nPort, string sInputPortFileName)
{
	m_mapInputPortFileNames.insert(std::pair<long, string>(nPort, sInputPortFileName));

}

void CDS_SystemManager::AddOutputPortFileName(long nPort, string sOutputPortFileName)
{
	m_mapOutputPortFileNames.insert(std::pair<long, string>(nPort, sOutputPortFileName));

}

bool CDS_SystemManager::LoadInputDataFromFiles()
{

	bool bLoad;
	if (GetNumberOfInputPorts() != m_mapInputPortFileNames.size())
		return false;

	long nSignalType = 0;
	string sFile = "";

	for (int i = 0; i < GetNumberOfInputPorts(); i++)
	{
				
		CDS_SignalBase* pSignal = GetSignalFromInputPort(i + 1);
		sFile = GetInputPortFileFolder(i + 1);
		if (pSignal != NULL)
		{			
			bLoad = pSignal->LoadCppFormat(sFile);
		}		
	}

	return true;
}

bool CDS_SystemManager::SaveOutputDataToFiles()
{
	
	bool bLoad = false;
	if (GetNumberOfOutputPorts() != m_mapOutputPortFileNames.size())
		return bLoad;

	string sFile = "";

	for (int i = 0; i < GetNumberOfOutputPorts(); i++)
	{		
		
		CDS_SignalBase* pSignal = GetSignalFromOutputPort(i + 1);
		sFile = GetOutputPortFileFolder(i + 1);
		if (pSignal != NULL)
		{			
			bLoad = pSignal->SaveCppFormat(sFile);
		}
		
	}

	return bLoad;
}

void CDS_SystemManager::DeleteAllGraphs_API()
{
	RemoveAllGraphs();
}

void CDS_SystemManager::ExportGraphs_API(STRINGVECTOR& pccGraphsNames, STRINGVECTOR& pccMainTitle, STRINGVECTOR& pccTitleX, STRINGVECTOR& pccTitleY,
	DOUBLEVECTORS& pccDataX, DOUBLEVECTORS& pccDataY, LONGVECTORS& pccSizeArr)

{
	map2DGraphs::iterator it;

	long nSize = m_map2DGraphs.size();

	pccGraphsNames.resize(nSize);
	pccMainTitle.resize(nSize);
	pccTitleX.resize(nSize);
	pccTitleY.resize(nSize);
	pccDataX.resize(nSize);
	pccDataY.resize(nSize);
	pccSizeArr.resize(nSize);

	string sGraphName;
	CDS_2DGraph* p2DGraph;

	long nIndex = 0;
	for (it = m_map2DGraphs.begin(); it != m_map2DGraphs.end(); it++)
	{
		sGraphName = it->first;  // string (key)
		p2DGraph = it->second;   // string's value 

		pccGraphsNames[nIndex] = sGraphName;

		pccMainTitle[nIndex] = p2DGraph->GetGraphTitle();
		pccTitleX[nIndex] = p2DGraph->GetTitleX();
		pccTitleY[nIndex] = p2DGraph->GetTitleY();


		if (p2DGraph->GetNrOfPoints() > 0)
		{
			pccDataX[nIndex].resize(p2DGraph->GetNrOfPoints());
			double* dpX = NULL;

			dpX = p2DGraph->GetXData();
			for (int j = 0; j < p2DGraph->GetNrOfPoints(); j++)
			{
				pccDataX[nIndex][j] = dpX[j];
			}

			pccDataY[nIndex].resize(p2DGraph->GetNrOfPoints());
			double* dpY = NULL;

			dpY = p2DGraph->GetYData();
			for (int j = 0; j < p2DGraph->GetNrOfPoints(); j++)
			{
				pccDataY[nIndex][j] = dpY[j];
			}
		}

		if (p2DGraph->GetSizeofSizeArray() > 0)
		{
			pccSizeArr[nIndex].resize(p2DGraph->GetSizeofSizeArray());

			long* npS = p2DGraph->GetSizeArray();

			for (int j = 0; j < p2DGraph->GetSizeofSizeArray(); j++)
			{
				pccSizeArr[nIndex][j] = npS[j];

			}
		}

		nIndex++;
	}
}

void CDS_SystemManager::ExportResults_API(STRINGVECTOR& pccResultsNames, DOUBLEVECTOR& pccResultsValues)
{

	mapResults::iterator it;

	long nSize = m_mapResults.size();

	pccResultsNames.resize(nSize);
	pccResultsValues.resize(nSize);

	string sResultName;
	double dValue;

	long nIndex = 0;
	for (it = m_mapResults.begin(); it != m_mapResults.end(); it++)
	{
		sResultName = it->first;  // string (key)
		dValue = it->second;   // string's value 

		pccResultsNames[nIndex] = sResultName;
		pccResultsValues[nIndex] = dValue;
		nIndex++;
	}
}

void CDS_SystemManager::SendMessageToConsole_API(STRINGVECTOR& sSendMessage)
{

	long nSize = m_sConsoleMessages.size();

	sSendMessage.resize(nSize);
	

	

	long nIndex = 0;
	for (int i = 0; i < nSize; i++)
	{
		sSendMessage[i] = m_sConsoleMessages[i];
	}


}

void CDS_SystemManager::AddDisplayMessageToConsole(string smessage)
{

	m_sConsoleMessages.push_back(smessage);

}

void CDS_SystemManager::ClearAllConsoleMessages()
{

	m_sConsoleMessages.clear();
}




void CDS_SystemManager::LoadXMLIniFile(char *docname)
{
	//TODO remove all global parameters
	ResetArrayInputSignalPorts_API();
	ResetArrayOutputSignalPorts_API();

	ClearAllInputPortFileNames();
	ClearAllOutputPortFileNames();

	xmlDocPtr doc;
	xmlNodePtr cur;

	doc = xmlParseFile(docname);

	if (doc == NULL)
	{
		//Print("Document not parsed successfully");
		//fprintf(stderr,"Document not parsed successfully. \n");
		return;
	}

	cur = xmlDocGetRootElement(doc);

	if (cur == NULL)
	{
		//Print("Empty document");
		//fprintf(stderr,"empty document\n");
		xmlFreeDoc(doc);
		return;
	}

	if (xmlStrcmp(cur->name, (const xmlChar *) "CPPCosimulation_output_parameters"))
	{
		//Print("document of the wrong type, root node != CPPCosimulation_output_parameters");
		//fprintf(stderr,"document of the wrong type, root node != story");
		xmlFreeDoc(doc);
		return;
	}
	ParseGlobalParameters(doc, cur);
	ParseXMLPortData(doc, cur);
	xmlFreeDoc(doc);

	LoadInputDataFromFiles();
	return;
}

void CDS_SystemManager::ParseParameter(xmlDocPtr doc, xmlNodePtr cur)
{
	string sParameterName;
	cur = cur->xmlChildrenNode;
	xmlNodePtr curPChildren;

	while (cur != NULL)
	{
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"PARAMETER")))
		{

			CDS_Parameter par;

			xmlChar * content;

			curPChildren = cur->children;
			while (curPChildren != NULL)
			{

				if ((!xmlStrcmp(curPChildren->name, (const xmlChar *)"NAME")))
				{

					content = xmlNodeGetContent(curPChildren);
					if (content != NULL)
					{
						sParameterName = string((char*)content);

						par.SetParameterName(sParameterName);

						xmlFree(content);
					}
				}
				//TYPE
				if ((!xmlStrcmp(curPChildren->name, (const xmlChar *)"TYPE")))
				{

					content = xmlNodeGetContent(curPChildren);
					if (content != NULL)
					{
						string sParameterType = string((char*)content);

						if (sParameterType == "BOOL")
							par.SetParameterType(CDS_Parameter::typeBOOL);
						else if (sParameterType == "STRING")
							par.SetParameterType(CDS_Parameter::typeString);
						else if (sParameterType == "CHOICE")
							par.SetParameterType(CDS_Parameter::typeChoice);
						else if (sParameterType == "DOUBLE")
							par.SetParameterType(CDS_Parameter::typeDouble);
						else if (sParameterType == "LONG")
							par.SetParameterType(CDS_Parameter::typeLong);

						xmlFree(content);
					}
				}
				if ((!xmlStrcmp(curPChildren->name, (const xmlChar *)"VALUE")))
				{
					content = xmlNodeGetContent(curPChildren);
					if (content != NULL)
					{

						string sParameterValue = string((char*)content);

						if (par.GetParameterType() == CDS_Parameter::typeBOOL)
						{
							if (sParameterValue == "TRUE")
								par.SetParameterBool(true);
							else
								par.SetParameterBool(false);
						}

						else if (par.GetParameterType() == CDS_Parameter::typeString)
						{
							par.SetParameterString(sParameterValue, false);
						}

						else if (par.GetParameterType() == CDS_Parameter::typeChoice)
						{
							//par.SetParameterChoiceList(sChoiceList);
							//par.SetParameterChoice(sChoice);

						}

						else if (par.GetParameterType() == CDS_Parameter::typeDouble)
						{
							double dValueDouble;
							dValueDouble = atof(sParameterValue.c_str());
							par.SetParameterDouble(dValueDouble);
						}

						else if (par.GetParameterType() == CDS_Parameter::typeLong)
						{
							long nValueLong;
							nValueLong = atol(sParameterValue.c_str());
							par.SetParameterLong(nValueLong);
						}

						xmlFree(content);
					}
				}
				if ((!xmlStrcmp(curPChildren->name, (const xmlChar *)"RANGE")))
				{
					content = xmlNodeGetContent(curPChildren);
					if (content != NULL)
					{
						string sParameterRange = string((char*)content);

						if (par.GetParameterType() == CDS_Parameter::typeDouble)
						{
							par.SetParameterMinMax(sParameterRange);
						}

						else if (par.GetParameterType() == CDS_Parameter::typeLong)
						{
							par.SetParameterMinMax(sParameterRange);
						}
						else if (par.GetParameterType() == CDS_Parameter::typeChoice)
						{
							par.SetParameterChoiceList(sParameterRange);
						}


						xmlFree(content);
					}
				}
				if ((!xmlStrcmp(curPChildren->name, (const xmlChar *)"UNIT")))
				{
					content = xmlNodeGetContent(curPChildren);
					if (content != NULL)
					{
						string sParameterUnit = string((char*)content);
						par.SetParameterUnit(sParameterUnit);
						xmlFree(content);
					}
				}


				curPChildren = curPChildren->next;
			}

			m_ParameterMgr.AddGlobalParameter(par.GetParameterName(), par);

		}

		cur = cur->next;
	}

}


void CDS_SystemManager::InitializeGlobals()
{
	CGlobalFrequencyGrid::SetFrequencyGridSpacing(1.0 / GetGlobalParameterDouble("Time window"));
	CGlobalSpaceGrid::SetGridSpacingX(1e-6 * GetGlobalParameterDouble("Grid spacing X"));
	CGlobalSpaceGrid::SetGridSpacingY(1e-6 * GetGlobalParameterDouble("Grid spacing Y"));

}


void CDS_SystemManager::ParseGlobalParameters(xmlDocPtr doc, xmlNodePtr cur)
{	
	cur = cur->xmlChildrenNode;
	xmlNodePtr curPChildren;

	while (cur != NULL)
	{
		
		if (!(xmlStrcmp(cur->name, (const xmlChar *)"GLOBALPARAMETERS")))
		{			
			ParseParameter(doc,  cur);
		}
		
		cur = cur->next;
	}

	return;
	//::MessageBeep(0xFFFFFFFF); //This makes windows beep
}

void CDS_SystemManager::ParseXMLPortData(xmlDocPtr doc, xmlNodePtr cur)
{
	//string sParameterName;
	xmlChar *temp;
	char *prop_name = "COUNT";
	char *prop_name2 = "PORTNUMBER";
	
	cur = cur->xmlChildrenNode;
	xmlNodePtr curPChildren;

	while (cur != NULL)
	{
		
		if (!(xmlStrcmp(cur->name, (const xmlChar *)"INPUTPORTS")))
		{
			temp = xmlGetProp(cur, (xmlChar*)prop_name);

			if (temp != NULL)
			{
				xmlFree(temp);
			}

			curPChildren = cur->children;
			long nCurPort = 1;
			while (curPChildren != NULL)
			{
				xmlChar * contentI;

				if ((!xmlStrcmp(curPChildren->name, (const xmlChar *)"INPUTPORT")))
				{
					contentI = xmlGetProp(curPChildren, (xmlChar*)prop_name2);
					if (contentI != NULL)
					{
						//string sPortN = string((char*)contentI);
						//nCurPort = atol(sPortN.c_str());
						nCurPort = atol((char*)contentI);
						xmlFree(contentI);
					}
					xmlNodePtr curPChildren2;
					curPChildren2 = curPChildren->children;

					xmlChar * content;
					
					while (curPChildren2 != NULL)
					{
						if ((!xmlStrcmp(curPChildren2->name, (const xmlChar *)"SIGNALTYPE")))
						{
							content = xmlNodeGetContent(curPChildren2);
							if (content != NULL)
							{
								string sSignalType = string((char*)content);
								if (sSignalType == "OpticalSignal")
									AddSignalToInputPortArray_API(nCurPort, typeOpticalSignal);
								else if (sSignalType == "ElectricalSignal")
									AddSignalToInputPortArray_API(nCurPort, typeElectricalSignal);
								else if (sSignalType == "BinarySignal")
									AddSignalToInputPortArray_API(nCurPort, typeBinarySignal);
								else if (sSignalType == "MarySignal")
									AddSignalToInputPortArray_API(nCurPort, typeMarySignal);
								
								xmlFree(content);
							}
						}
						else if ((!xmlStrcmp(curPChildren2->name, (const xmlChar *)"FILEFOLDER")))
						{
							content = xmlNodeGetContent(curPChildren2);
							if (content != NULL)
							{
								
								string sFileFolder = string((char*)content);								
								AddInputPortFileName(nCurPort, sFileFolder);

								xmlFree(content);
							}
						}

						curPChildren2 = curPChildren2->next;
					}
					//::MessageBeep(0xFFFFFFFF); //This makes windows beep
				}
				
				curPChildren = curPChildren->next;

			}
		}
		else if (!(xmlStrcmp(cur->name, (const xmlChar *)"OUTPUTPORTS")))
		{
			temp = xmlGetProp(cur, (xmlChar*)prop_name);

			if (temp != NULL)
			{
				xmlFree(temp);
			}

			curPChildren = cur->children;
			long nCurPort = 1;
			while (curPChildren != NULL)
			{
				xmlChar * contentI;

				if ((!xmlStrcmp(curPChildren->name, (const xmlChar *)"OUTPUTPORT")))
				{
					contentI = xmlGetProp(curPChildren, (xmlChar*)prop_name2);
					if (contentI != NULL)
					{
						//string sPortN = string((char*)contentI);
						//nCurPort = atol(sPortN.c_str());
						nCurPort = atol((char*)contentI);
						xmlFree(contentI);
					}
					xmlNodePtr curPChildren2;
					curPChildren2 = curPChildren->children;

					xmlChar * content;

					while (curPChildren2 != NULL)
					{
						if ((!xmlStrcmp(curPChildren2->name, (const xmlChar *)"SIGNALTYPE")))
						{
							content = xmlNodeGetContent(curPChildren2);
							if (content != NULL)
							{
								string sSignalType = string((char*)content);
								if (sSignalType == "OpticalSignal")
									AddSignalToOutputPortArray_API(nCurPort, typeOpticalSignal);
								else if (sSignalType == "ElectricalSignal")
									AddSignalToOutputPortArray_API(nCurPort, typeElectricalSignal);
								else if (sSignalType == "BinarySignal")
									AddSignalToOutputPortArray_API(nCurPort, typeBinarySignal);
								else if (sSignalType == "MarySignal")
									AddSignalToOutputPortArray_API(nCurPort, typeMarySignal);

								xmlFree(content);
							}
						}
						else if ((!xmlStrcmp(curPChildren2->name, (const xmlChar *)"FILEFOLDER")))
						{
							content = xmlNodeGetContent(curPChildren2);
							if (content != NULL)
							{

								string sFileFolder = string((char*)content);
								AddOutputPortFileName(nCurPort, sFileFolder);

								xmlFree(content);
							}
						}

						curPChildren2 = curPChildren2->next;
					}

				}

				curPChildren = curPChildren->next;

			}
		}

		cur = cur->next;

	}
}





/////////////////////////////////////////////////////////////////////////////////////////
//Convenience function to output an information string to notepad
//////////////////////////////////////////////////////////////////////////////////////////

void CDS_SystemManager::Notepad(string buffer)
{


	int nRand = rand(); //to make new name for file so it doesn't conflict with any other temporary files

	//create temporary data file
	string fileName = "tempInfo" + to_string(nRand) + ".txt";
	ofstream NoteOut(fileName);
	NoteOut << buffer;

	NoteOut.close();


	//call script, put in own thread so it doesn't interfere with rest of calculations
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	ZeroMemory(&pi, sizeof(pi));

	string str = "cmd /K notepad " + fileName;
	LPSTR stringCmdLine = const_cast<char *>(str.c_str());

	//
	//// Start the child process. 
	if (!CreateProcess(NULL, // No module name (use command line). 
		stringCmdLine, // Command line. 
		NULL,             // Process handle not inheritable. 
		NULL,             // Thread handle not inheritable. 
		FALSE,            // Set handle inheritance to FALSE. 
		DETACHED_PROCESS,                // No creation flags. 
		NULL,             // Use parent's environment block. 
		NULL,             // Use parent's starting directory. 
		&si,              // Pointer to STARTUPINFO structure.
		&pi)             // Pointer to PROCESS_INFORMATION structure.
		)
	{
	}
	//// Wait until child process exits.
	//WaitForSingleObject(pi.hProcess, INFINITE);

	//// Close process and thread handles. 
	//CloseHandle(pi.hProcess);
	//CloseHandle(pi.hThread);
}






//////////////////////////////////////////////////////////////////////////////////////////
//Convenience plotting functions using gnuplot
//In order for these to work, you must have gnuplot for windows installed on your computer
//////////////////////////////////////////////////////////////////////////////////////////


void CDS_SystemManager::gnuplot2D(DOUBLEVECTOR x, DOUBLEVECTOR y, string title, string legend, string xlabel, string ylabel)
{


	int nRand = rand(); //to make new name for file so it doesn't conflict with any other temporary files

	//create temporary data file
	string fileName = "tempDat" + to_string(nRand) + ".dat";
	ofstream ViewOut(fileName);
	for (int i = 0; i < x.size(); i++)
	{
		ViewOut << x[i] << " " << y[i] << "\n";
	}
	ViewOut.close();

	//create gnuplot script file
	string scriptName = "plot" + to_string(nRand) + ".gp";
	ofstream scrip(scriptName);
	scrip << "set style data lines \n";
	scrip << "set title \"" + title + "\" \n";
	scrip << "set xlabel \"" + xlabel + "\" \n";
	scrip << "set ylabel \"" + ylabel + "\" \n";
	scrip << "plot '" + fileName + "' title '" + legend + "'   \n";
	scrip.close();


	//call script, put in own thread so it doesn't interfere with rest of calculations
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	ZeroMemory(&pi, sizeof(pi));

	string str = "cmd /K " + scriptName;
	LPSTR stringCmdLine = const_cast<char *>(str.c_str());

	//
	//// Start the child process. 
	if (!CreateProcess(NULL, // No module name (use command line). 
		stringCmdLine, // Command line. 
		NULL,             // Process handle not inheritable. 
		NULL,             // Thread handle not inheritable. 
		FALSE,            // Set handle inheritance to FALSE. 
		DETACHED_PROCESS,                // No creation flags. 
		NULL,             // Use parent's environment block. 
		NULL,             // Use parent's starting directory. 
		&si,              // Pointer to STARTUPINFO structure.
		&pi)             // Pointer to PROCESS_INFORMATION structure.
		)
	{
	}
	//// Wait until child process exits.
	//WaitForSingleObject(pi.hProcess, INFINITE);

	//// Close process and thread handles. 
	//CloseHandle(pi.hProcess);
	//CloseHandle(pi.hThread);
}


void CDS_SystemManager::gnuplot2D(DOUBLEVECTOR x1, DOUBLEVECTOR y1, DOUBLEVECTOR x2, DOUBLEVECTOR y2, string title, string legend1, string legend2, string xlabel, string ylabel)
{


	int nRand = rand(); //to make new name for file so it doesn't conflict with any other temporary files

	//create temporary data files
	string fileName1 = "tempDat" + to_string(nRand) + ".dat";
	ofstream dataOut1(fileName1);
	for (int i = 0; i < x1.size(); i++)
	{
		dataOut1 << x1[i] << " " << y1[i] << "\n";
	}
	dataOut1.close();


	string fileName2 = "tempDat" + to_string(nRand + 1) + ".dat";
	ofstream dataOut2(fileName2);
	for (int i = 0; i < x2.size(); i++)
	{
		dataOut2 << x2[i] << " " << y2[i] << "\n";
	}
	dataOut2.close();


	//create gnuplot script file
	string scriptName = "plot" + to_string(nRand) + ".gp";
	ofstream scrip(scriptName);
	scrip << "set style data lines \n";
	scrip << "set style data lines \n";
	scrip << "set title \"" + title + "\" \n";
	scrip << "set xlabel \"" + xlabel + "\" \n";
	scrip << "set ylabel \"" + ylabel + "\" \n";
	scrip << "plot '" + fileName1 + "' title '" + legend1 + "' , '" + fileName2 + "' title '" + legend2 + "' \n";
	scrip.close();



	//call script, put in own thread so it doesn't interfere with rest of calculations
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	ZeroMemory(&pi, sizeof(pi));

	string str = "cmd /K " + scriptName;
	LPSTR stringCmdLine = const_cast<char *>(str.c_str());

	//// Start the child process. 
	if (!CreateProcess(NULL, // No module name (use command line). 
		stringCmdLine, // Command line. 
		NULL,             // Process handle not inheritable. 
		NULL,             // Thread handle not inheritable. 
		FALSE,            // Set handle inheritance to FALSE. 
		DETACHED_PROCESS,                // No creation flags. 
		NULL,             // Use parent's environment block. 
		NULL,             // Use parent's starting directory. 
		&si,              // Pointer to STARTUPINFO structure.
		&pi)             // Pointer to PROCESS_INFORMATION structure.
		)
	{
	}
	//// Wait until child process exits.
	//WaitForSingleObject(pi.hProcess, INFINITE);

	//// Close process and thread handles. 
	//CloseHandle(pi.hProcess);
	//CloseHandle(pi.hThread);
}


void CDS_SystemManager::gnuplot3DTopViewRealVector(DOUBLEVECTOR x, DOUBLEVECTOR y, DOUBLEVECTOR z, string title, string xlabel, string ylabel)
{


	int nRand = rand(); //to make new name for file so it doesn't conflict with any other temporary files

	//create temporary data file
	string fileName = "tempDat" + to_string(nRand) + ".dat";
	ofstream ViewOut(fileName);
	for (int i = 0; i < x.size(); i++)
	{
		ViewOut << x[i] << " " << y[i] << " " << z[i] << " i \n";
	}
	ViewOut.close();

	//create gnuplot script file
	string scriptName = "plot" + to_string(nRand) + ".gp";
	ofstream scrip(scriptName);
	//scrip << "set style data lines \n";
	scrip << "set palette rgbformulae 33,13,10 \n";
	scrip << "set title \"" + title + "\" \n";
	scrip << "set xlabel \"" + xlabel + "\" \n";
	scrip << "set ylabel \"" + ylabel + "\" \n";
	scrip << "p '" + fileName + "' with image  notitle \n";
	scrip.close();


	//call script, put in own thread so it doesn't interfere with rest of calculations
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	ZeroMemory(&pi, sizeof(pi));

	string str = "cmd /K " + scriptName;
	LPSTR stringCmdLine = const_cast<char *>(str.c_str());

	//
	//// Start the child process. 
	if (!CreateProcess(NULL, // No module name (use command line). 
		stringCmdLine, // Command line. 
		NULL,             // Process handle not inheritable. 
		NULL,             // Thread handle not inheritable. 
		FALSE,            // Set handle inheritance to FALSE. 
		DETACHED_PROCESS,                // No creation flags. 
		NULL,             // Use parent's environment block. 
		NULL,             // Use parent's starting directory. 
		&si,              // Pointer to STARTUPINFO structure.
		&pi)             // Pointer to PROCESS_INFORMATION structure.
		)
	{
	}
	//// Wait until child process exits.
	//WaitForSingleObject(pi.hProcess, INFINITE);

	//// Close process and thread handles. 
	//CloseHandle(pi.hProcess);
	//CloseHandle(pi.hThread);
}

void CDS_SystemManager::gnuplot3DTopViewTransverseMode(CNDS_OpticalTransverseMode mode, string type, string title)
{
	mode.Normalize();

	int nRand = rand(); //to make new name for file so it doesn't conflict with any other temporary files

	//create temporary data file
	string fileName = "tempDat" + to_string(nRand) + ".dat";
	ofstream ViewOut(fileName);

	double minX = mode.GetMinX()*1.0e6;
	double minY = mode.GetMinY()*1.0e6;
	double dX = mode.GetDeltaX()*1.0e6;
	double dY = mode.GetDeltaY()*1.0e6;
	CComplex** ccData = mode.GetData();

	for (int i = 0; i < mode.GetSizeX(); i++)
	{
		for (int j = 0; j < mode.GetSizeY(); j++)
		{
			double dVal;
			if (type == "real")
			{
				dVal = real(ccData[i][j]);
			}
			else if (type == "imag")
			{
				dVal = imag(ccData[i][j]);
			}
			else if (type == "phase")
			{
				dVal = atan2(imag(ccData[i][j]), real(ccData[i][j]));
			}
			else
			{
				dVal = abs(ccData[i][j]);
			}
			ViewOut << minX + i*dX << " " << minY + j*dY << " " << dVal << " i \n";
		}
	}
	ViewOut.close();

	//create gnuplot script file
	string scriptName = "plot" + to_string(nRand) + ".gp";
	ofstream scrip(scriptName);
	//scrip << "set style data lines \n";
	scrip << "set palette rgbformulae 33,13,10 \n";
	//scrip << "set pm3d \n";
	scrip << "set title \"" + title + " : " + type + " : " + mode.GetProperties() + "\" \n";
	scrip << "set xlabel \" x (um) \" \n";
	scrip << "set ylabel \" y (um) \" \n";
	scrip << "p '" + fileName + "' with image  notitle \n";
	scrip.close();


	//call script, put in own thread so it doesn't interfere with rest of calculations
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	ZeroMemory(&pi, sizeof(pi));

	string str = "cmd /K " + scriptName;
	LPSTR stringCmdLine = const_cast<char *>(str.c_str());

	//
	//// Start the child process. 
	if (!CreateProcess(NULL, // No module name (use command line). 
		stringCmdLine, // Command line. 
		NULL,             // Process handle not inheritable. 
		NULL,             // Thread handle not inheritable. 
		FALSE,            // Set handle inheritance to FALSE. 
		DETACHED_PROCESS,                // No creation flags. 
		NULL,             // Use parent's environment block. 
		NULL,             // Use parent's starting directory. 
		&si,              // Pointer to STARTUPINFO structure.
		&pi)             // Pointer to PROCESS_INFORMATION structure.
		)
	{
	}
	//// Wait until child process exits.
	//WaitForSingleObject(pi.hProcess, INFINITE);

	//// Close process and thread handles. 
	//CloseHandle(pi.hProcess);
	//CloseHandle(pi.hThread);
}



void CDS_SystemManager::gnuplot3DSurfaceRealVector(DOUBLEVECTOR x, DOUBLEVECTOR y, DOUBLEVECTOR z, string title, string xlabel, string ylabel)
{


	int nRand = rand(); //to make new name for file so it doesn't conflict with any other temporary files

	//create temporary data file
	string fileName = "tempDat" + to_string(nRand) + ".dat";
	ofstream ViewOut(fileName);
	for (int i = 0; i < x.size(); i++)
	{
		ViewOut << x[i] << " " << y[i] << " " << z[i] << " i \n";
	}
	ViewOut.close();

	//create gnuplot script file
	string scriptName = "plot" + to_string(nRand) + ".gp";
	ofstream scrip(scriptName);
	//scrip << "set style data lines \n";
	scrip << "set pm3d \n";
	scrip << "set title \"" + title + "\" \n";
	scrip << "set xlabel \"" + xlabel + "\" \n";
	scrip << "set ylabel \"" + ylabel + "\" \n";
	scrip << "set hidden3d \n";
	scrip << "set dgrid3d 50,50 qnorm 2 \n";
	scrip << "splot '" + fileName + "' with lines notitle \n";
	scrip.close();


	//call script, put in own thread so it doesn't interfere with rest of calculations
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	ZeroMemory(&pi, sizeof(pi));

	string str = "cmd /K " + scriptName;
	LPSTR stringCmdLine = const_cast<char *>(str.c_str());

	//
	//// Start the child process. 
	if (!CreateProcess(NULL, // No module name (use command line). 
		stringCmdLine, // Command line. 
		NULL,             // Process handle not inheritable. 
		NULL,             // Thread handle not inheritable. 
		FALSE,            // Set handle inheritance to FALSE. 
		DETACHED_PROCESS,                // No creation flags. 
		NULL,             // Use parent's environment block. 
		NULL,             // Use parent's starting directory. 
		&si,              // Pointer to STARTUPINFO structure.
		&pi)             // Pointer to PROCESS_INFORMATION structure.
		)
	{
	}
	//// Wait until child process exits.
	//WaitForSingleObject(pi.hProcess, INFINITE);

	//// Close process and thread handles. 
	//CloseHandle(pi.hProcess);
	//CloseHandle(pi.hThread);
}


void CDS_SystemManager::gnuplot3DSurfaceTransverseMode(CNDS_OpticalTransverseMode mode, string type, string title)
{
	mode.Normalize();

	int nRand = rand(); //to make new name for file so it doesn't conflict with any other temporary files

	//create temporary data file
	string fileName = "tempDat" + to_string(nRand) + ".dat";
	ofstream ViewOut(fileName);

	double minX = mode.GetMinX()*1.0e6;
	double minY = mode.GetMinY()*1.0e6;
	double dX = mode.GetDeltaX()*1.0e6;
	double dY = mode.GetDeltaY()*1.0e6;
	CComplex** ccData = mode.GetData();

	for (int i = 0; i < mode.GetSizeX(); i++)
	{
		for (int j = 0; j < mode.GetSizeY(); j++)
		{
			double dVal;
			if (type == "real")
			{
				dVal = real(ccData[i][j]);
			}
			else if (type == "imag")
			{
				dVal = imag(ccData[i][j]);
			}
			else if (type == "phase")
			{
				dVal = atan2(imag(ccData[i][j]), real(ccData[i][j]));
			}
			else
			{
				dVal = abs(ccData[i][j]);
			}
			ViewOut << minX + i*dX << " " << minY + j*dY << " " << dVal << " i \n";
		}
	}
	ViewOut.close();

	//create gnuplot script file
	string scriptName = "plot" + to_string(nRand) + ".gp";
	ofstream scrip(scriptName);
	//scrip << "set style data lines \n";
	scrip << "set pm3d \n";
	scrip << "set title \"" + title + " : " + type + " : " + mode.GetProperties() + "\" \n";
	scrip << "set xlabel \" x (um) \" \n";
	scrip << "set ylabel \" y (um) \" \n";
	scrip << "set hidden3d \n";
	scrip << "set dgrid3d 50,50 qnorm 2 \n";
	scrip << "splot '" + fileName + "' with lines notitle \n";
	scrip.close();


	//call script, put in own thread so it doesn't interfere with rest of calculations
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	ZeroMemory(&pi, sizeof(pi));

	string str = "cmd /K " + scriptName;
	LPSTR stringCmdLine = const_cast<char *>(str.c_str());

	//
	//// Start the child process. 
	if (!CreateProcess(NULL, // No module name (use command line). 
		stringCmdLine, // Command line. 
		NULL,             // Process handle not inheritable. 
		NULL,             // Thread handle not inheritable. 
		FALSE,            // Set handle inheritance to FALSE. 
		DETACHED_PROCESS,                // No creation flags. 
		NULL,             // Use parent's environment block. 
		NULL,             // Use parent's starting directory. 
		&si,              // Pointer to STARTUPINFO structure.
		&pi)             // Pointer to PROCESS_INFORMATION structure.
		)
	{
	}
	//// Wait until child process exits.
	//WaitForSingleObject(pi.hProcess, INFINITE);

	//// Close process and thread handles. 
	//CloseHandle(pi.hProcess);
	//CloseHandle(pi.hThread);
}

//////////////////////////////////////////////////////////////////////////////////////////
//Convenience plotting functions using gnuplot
//In order for these to work, you must have gnuplot for windows installed on your computer
//////////////////////////////////////////////////////////////////////////////////////////

