#pragma once

#include "..\CommonUtilitiesLibrary\Utilities.h"
#include "..\CommonUtilitiesLibrary\Console.h"

#include "..\SignalLibrary\DS_BinarySignal.h";
#include "..\SignalLibrary\DS_MarySignal.h"
#include "..\SignalLibrary\DS_ElectricalSignal.h"
#include "..\SignalLibrary\DS_OpticalSignal.h"

#include "..\SignalLibrary\DS_SignalBase.h"

#include "..\LibXML2\include\libxml\xmlmemory.h"
#include "..\LibXML2\include\libxml\parser.h"

#include "DS_2DGraph.h"
#include "DS_Parameter.h"
#include "DS_ParameterMgr.h"



#include "math.h" 

#include "..\SignalLibrary\ElectricalSignal.h"

#include "..\CommonUtilitiesLibrary\CGlobalSpaceGrid.h"

#include "..\SignalLibrary\NDS_OpticalParameterizedSignalsData.h"
#include "..\SignalLibrary\NDS_OpticalIndividualSamplesData.h"

#include "..\SignalLibrary\NDS_ElectricalIndividualSample.h"
#include "..\SignalLibrary\NDS_ElectricalSampledNoise.h"
#include "..\NumericalProcedures\NP_WitchmanHillSeedsTable.h"


#include "..\ModeSolverCalculationLibrary\NP_ChangeTransverseModes.h"
#include "..\ModeSolverCalculationLibrary\NP_LaguerreGaussianMode.h"


#include <fstream>      // std::fstream


typedef std::map<long, CDS_SignalBase*> mapPortSignal;
typedef std::map<string, double> mapResults;
typedef std::map<string, CDS_2DGraph*> map2DGraphs;
typedef std::map<long, string> mapPortFileNames;


typedef std::vector< CNDS_OpticalSampledSignal>	VECTOR_OpticalSampledSignals;
typedef std::vector< CNDS_OpticalParameterizedSignal>	VECTOR_OpticalParameterizedSignals;
typedef std::vector< CNDS_OpticalIndividualSample>	VECTOR_OpticalIndividualSamples;
typedef std::vector< CNDS_OpticalNoiseBin>	VECTOR_OpticalNoiseBins;
//vector classes for data from ports in convenience functions



class CDS_SystemManager
{
private:
	static bool instanceFlag ;
	static CDS_SystemManager *single;
	CDS_SystemManager();
public:

	/////////////////////user defined functions
	void lowPassFilterRect(CNDS_OpticalSampledSignal& opticalField, double timeConstant);
	/////////////////////user defined functions

	bool m_bInExecutableMode; //flag to tell us if we are generating a dll or an executable

	static CDS_SystemManager* getInstance();

	CDS_SystemManager(CDS_SystemManager const&);
	void operator=(CDS_SystemManager const&);
	
	~CDS_SystemManager();

	STRINGVECTOR m_sConsoleMessages;

	void AddDisplayMessageToConsole(string smessage);
	void ClearAllConsoleMessages();

	CDS_SignalBase* GetSignalFromInputPort(long nInputPort);
	CDS_SignalBase* GetSignalFromOutputPort(long nOutputPort);	

	double GetGlobalParameterDouble(string strName);
	double GetParameterDouble(string strName);
	bool GetGlobalParameterBool(string strName);
	bool GetParameterBool(string strName);
	long GetGlobalParameterLong(string strName);
	long GetParameterLong(string strName);
	string GetParameterString(string strName);

	void AddResult(string sResultName, double dValue);
	void ClearAllResults();

	void Allocate2DGraph(string sGraphName);
	CDS_2DGraph* Get2DGraph(string sGraphName);
	void RemoveAllGraphs();

	long GetNumberOfInputPorts();
	long GetNumberOfOutputPorts();
	long GetSignalTypeInputPort(long nInputPort);
	long GetSignalTypeOutputPort(long nOutputPort);

	//Loading data from files
	void ClearAllInputPortFileNames();
	void ClearAllOutputPortFileNames();
	void AddInputPortFileName(long nPort, string sInputPortFileName);
	void AddOutputPortFileName(long nPort, string sOutputPortFileName);
	string GetInputPortFileFolder(long nInputPort);
	string GetOutputPortFileFolder(long nOutputPort);
	bool LoadInputDataFromFiles();
	bool SaveOutputDataToFiles();

	enum enumSignalType
	{
		typeOpticalSignal,
		typeElectricalSignal,
		typeBinarySignal,
		typeMarySignal
	};

	enum enumSignalDomain
	{
		domainTime,
		domainFrequency
	};

	CDS_ParameterMgr m_ParameterMgr;

	long m_nInputPorts;
	long m_nOutputPorts;
	
	mapPortSignal m_mapInputPortSignal;
	mapPortSignal m_mapOutputPortSignal;

	mapResults		m_mapResults;
	map2DGraphs		m_map2DGraphs;

	mapPortFileNames  m_mapInputPortFileNames;
	mapPortFileNames  m_mapOutputPortFileNames;


	CNP_FFTWPlan	m_Plan;
	//for FFT functions

	//external
	void ResetArrayInputSignalPorts_API();
	void ResetArrayOutputSignalPorts_API();
	void AddSignalToInputPortArray_API(long nInputPort, long nSignalType);
	void AddSignalToOutputPortArray_API(long nOutputPort, long nSignalType);
	void PutBinarySignal_API(long nInputPort, LONGVECTOR& rarrBits, double dBitRate);
	bool GetBinarySignal_API(long nOutputPort, LONGVECTOR& rarrBits, double& dBitRate);
	void PutMarySignal_API(long nInputPort, DOUBLEVECTOR& rarrBits, double dBitRate);
	bool GetMarySignal_API(long nOutputPort, DOUBLEVECTOR& rarrSymbols, double& dSymbolRate);
	void PutElectricalSampledSignal_API(long nInputPort, CComplex* pccE, long nSize, double dSampleRate);
	void GetElectricalSampledSignalSize_API(long nOutputPort, long& nSize);
	void GetElectricalSampledSignal_API(long nOutputPort, COMPLEXVECTOR& pccE, double& dSampleRate);
	void PutElectricalIndividualSampledSignal_API(long nInputPort, CComplex* pccE, long nSize, double dSampleRate);
	void GetElectricalIndividualSampledSignal_API(long nOutputPort, COMPLEXVECTOR& pccE, double& dSampleRate);
	void PutElectricalSampledNoiseSignal_API(long nInputPort, CComplex* pccE, long nSize, double dSampleRate);
	void GetElectricalSampledNoiseSignalSize_API(long nOutputPort, long& nSize);
	void GetElectricalSampledNoiseSignal_API(long nOutputPort, COMPLEXVECTOR& pccE, /* DOUBLEVECTOR &pccFreq,*/ double& dSampleRate);
	void PutElectricalSampledNoiseArray_API(long nInputPort, COMPLEXVECTORS& pccE, COMPLEXVECTORS& pccNormalizedPSD, DOUBLEVECTOR& vecSampleRate);
	void GetElectricalSampledNoiseArray_API(long nOutputPort, COMPLEXVECTORS& pccE, COMPLEXVECTORS& pccNormalizedPSD, DOUBLEVECTOR& vecSampleRate);
	void GetElectricalSampledNoiseArraySize_API(long nOutputPort, long& nSize);	
	void AddParameterBOOL_API(string sName, bool bValueBool, bool bCppComponent);
	void AddParameterLONG_API(string sName, long bValueLong, string sUnit, long nMin, long nMax, bool bCppComponent);
	void AddParameterSTRING_API(string sName, string sValueString, bool bFilename, bool bCppComponent);
	void AddParameterDOUBLE_API(string sName, double dValueDouble, string sUnit, double dMin, double dMax, bool bCppComponent);
	void AddParameterCHOICE_API(string sName, string sChoice, string sChoiceList, bool bCppComponent);
	void ClearAllParameters_API();
	void SetGlobalFrequencyGridSpacing_API(double dFrequencyGridSpacing);
	void SetGlobalNoiseBinResolution_API(long nNoiseBinResolution);
	void SetGlobalGridSpacingX_API(double dGridSpacing);
	void SetGlobalGridSpacingY_API(double dGridSpacing);
	void SetOpticalSignalFrequencyGrid_API(long nInputPort, double dFrequencyGridSpacing, double dGridSpacingX, double dGridSpacingY);
	void PutOpticalIndividualSamples_API(long nInputPort, COMPLEXVECTOR& pccAmpX, COMPLEXVECTOR& pccAmpY, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq);
	void GetOpticalIndividualSamples_API(long nOutputPort, COMPLEXVECTOR& pccAmpX, COMPLEXVECTOR& pccAmpY, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq);
	void PutOpticalNoise_API(long nInputPort, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq, DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference);
	void GetOpticalNoise_API(long nOutputPort, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq, DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference);
	void PutOpticalParameterized_API(long nInputPort, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq, DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference);
	void GetOpticalParameterized_API(long nOutputPort, DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq, DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference);
	void SetOpticalChannels_API(long nInputPort, DOUBLEVECTOR& pccChannels);
	void GetOpticalChannels_API(long nOutputPort, DOUBLEVECTOR& pccChannels);
	void PutOpticalSampled_API(long nInputPort, LONGVECTOR& pccTotalField,
		DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq,
		COMPLEXVECTORS& pccAmplX, COMPLEXVECTORS& pccAmplY,
		DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference,
		COMPLEXVECTORS& pccModeX, LONGVECTOR& pccMXsizeX, LONGVECTOR& pccMXsizeY,
		COMPLEXVECTORS& pccModeY, LONGVECTOR& pccMYsizeX, LONGVECTOR& pccMYsizeY,
		STRINGVECTOR& pccModePropX, STRINGVECTOR& pccModePropY,
		DOUBLEVECTOR& pccPhaseDelayX, DOUBLEVECTOR& pccPhaseDelayY);
	void GetOpticalSampled_API(long nOutputPort, LONGVECTOR& pccTotalField,
		DOUBLEVECTOR& pccLowerFreq, DOUBLEVECTOR& pccUpperFreq,
		COMPLEXVECTORS& pccAmplX, COMPLEXVECTORS& pccAmplY,
		DOUBLEVECTOR& pccPower, DOUBLEVECTOR& pccSplittingRatio, DOUBLEVECTOR& pccPhaseDifference,
		COMPLEXVECTORS& pccModeX, LONGVECTOR& pccMXsizeX, LONGVECTOR& pccMXsizeY,
		COMPLEXVECTORS& pccModeY, LONGVECTOR& pccMYsizeX, LONGVECTOR& pccMYsizeY,
		STRINGVECTOR& pccModePropX, STRINGVECTOR& pccModePropY,
		DOUBLEVECTOR& pccPhaseDelayX, DOUBLEVECTOR& pccPhaseDelayY);
	void DeleteAllGraphs_API();
	void ExportGraphs_API(STRINGVECTOR& pccGraphsNames, STRINGVECTOR& pccMainTitle, STRINGVECTOR& pccTitleX, STRINGVECTOR& pccTitleY,
		DOUBLEVECTORS& pccDataX, DOUBLEVECTORS& pccDataY, LONGVECTORS& pccSizeArr);
	void ExportResults_API(STRINGVECTOR& pccResultsNames, DOUBLEVECTOR& pccResultsValues);
	void SendMessageToConsole_API(STRINGVECTOR& sSendMessage);
	bool Calculate_API();


	/////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Convenience functions

	//Functions for getting and putting Mary signals from/to the ports
	CDS_MarySignal GetMarySignal(CDS_SignalBase* pSignalBase);
	void PutMarySignal(CDS_MarySignal marySignal, CDS_SignalBase* pSignalBase);

	//Functions for getting and putting binary signals from/to the ports
	CDS_BinarySignal GetBinarySignal(CDS_SignalBase* pSignalBase);
	void PutBinarySignal(CDS_BinarySignal binarySignal, CDS_SignalBase* pSignalBase);

	//Functions for getting and putting optical signals from/to the ports
	VECTOR_OpticalSampledSignals GetOpticalSampledSignalsVector(CDS_SignalBase* pSignalBase);
	void  PutOpticalSampledSignalsVector(VECTOR_OpticalSampledSignals vecSampledSignals, CDS_SignalBase* pOOSignal);

	VECTOR_OpticalParameterizedSignals GetOpticalParameterizedSignalsVector(CDS_SignalBase* pSignalBase);
	void  PutOpticalParameterizedSignalsVector(VECTOR_OpticalParameterizedSignals vecParamSignals, CDS_SignalBase* pOOSignal);

	VECTOR_OpticalIndividualSamples GetOpticalIndividualSamplesVector(CDS_SignalBase* pSignalBase);
	void  PutOpticalIndividualSamplesVector(VECTOR_OpticalIndividualSamples vecIndividualSamples, CDS_SignalBase* pOOSignal);

	VECTOR_OpticalNoiseBins GetOpticalNoiseBinsVector(CDS_SignalBase* pSignalBase);
	void  PutOpticalNoiseBinsVector(VECTOR_OpticalNoiseBins vecNoiseBins, CDS_SignalBase* pOOSignal);

	//Functions for getting and putting electrical signals from/to the ports
	CNDS_ElectricalSampledSignal GetElectricalSampledSignal(CDS_SignalBase* pIOSignal1);
	void PutElectricalSampledSignal(CNDS_ElectricalSampledSignal sampledSignal, CDS_SignalBase* pOOSignal1);

	CNDS_ElectricalSampledSignal GetElectricalSampledNoise(CDS_SignalBase* pIOSignal1);
	void PutElectricalSampledNoise(CNDS_ElectricalSampledSignal sampledNoise, CDS_SignalBase* pOOSignal1);

	CNDS_ElectricalIndividualSample GetElectricalIndividualSample(CDS_SignalBase* pIOSignal1);
	void PutElectricalIndividualSample(CNDS_ElectricalIndividualSample individualSample, CDS_SignalBase* pOOSignal1);
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


	//XML
	void LoadXMLIniFile(char *docname);
	void ParseGlobalParameters(xmlDocPtr doc, xmlNodePtr cur);
	void ParseXMLPortData(xmlDocPtr doc, xmlNodePtr cur);
	void ParseParameter(xmlDocPtr doc, xmlNodePtr cur);

	void InitializeGlobals();
	//set global variables of frequency grid and sapce grid. Important for debug mode.



	/////////////////////////////////////////////////////////////////////////////////////////
	//Convenience function to output an information string to notepad
	//////////////////////////////////////////////////////////////////////////////////////////
	void Notepad(string buffer);

	//////////////////////////////////////////////////////////////////////////////////////////
	//Convenience plotting functions using gnuplot
	//In order for these to work, you must have gnuplot for windows installed on your computer
	//////////////////////////////////////////////////////////////////////////////////////////
	void gnuplot2D(DOUBLEVECTOR x, DOUBLEVECTOR y, string title = "", string legend = "", string xlabel = "", string ylabel = "");
	void gnuplot2D(DOUBLEVECTOR x1, DOUBLEVECTOR y1, DOUBLEVECTOR x2, DOUBLEVECTOR y2, string title = "", string legend1 = "", string legend2 = "", string xlabel = "", string ylabel = "");
	void gnuplot3DTopViewRealVector(DOUBLEVECTOR x, DOUBLEVECTOR y, DOUBLEVECTOR z, string title = "", string xlabel = "", string ylabel = "");
	void gnuplot3DSurfaceRealVector(DOUBLEVECTOR x, DOUBLEVECTOR y, DOUBLEVECTOR z, string title = "", string xlabel = "", string ylabel = "");
	void gnuplot3DTopViewTransverseMode(CNDS_OpticalTransverseMode mode, string type = "abs", string title = "");
	void gnuplot3DSurfaceTransverseMode(CNDS_OpticalTransverseMode mode, string type = "abs", string title = "");
};

